package software.amazon.awscdk.integtests;

/**
 * (experimental) Represents the "expected" results to compare.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * App app;
 * IntegTest integ;
 * integ.assertions.awsApiCall("SQS", "sendMessage", Map.of(
 *         "QueueUrl", "url",
 *         "MessageBody", "hello"));
 * IAwsApiCall message = integ.assertions.awsApiCall("SQS", "receiveMessage", Map.of(
 *         "QueueUrl", "url"));
 * message.expect(ExpectedResult.objectLike(Map.of(
 *         "Messages", List.of(Map.of("Body", "hello")))));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:29:12.917Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.integ_tests.ExpectedResult")
public abstract class ExpectedResult extends software.amazon.jsii.JsiiObject {

    protected ExpectedResult(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ExpectedResult(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected ExpectedResult() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * (experimental) The actual results must be a list and must contain an item with the expected results.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // actual results
     * Map&lt;String, String&gt;[] actual = List.of(Map.of(
     *         "stringParam", "hello"), Map.of(
     *         "stringParam", "world"));
     * // pass
     * ExpectedResult.arrayWith(List.of(Map.of(
     *         "stringParam", "hello")));
     * </pre></blockquote>
     * <p>
     * @param expected This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.integtests.ExpectedResult arrayWith(final @org.jetbrains.annotations.NotNull java.util.List<? extends java.lang.Object> expected) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.integtests.ExpectedResult.class, "arrayWith", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.integtests.ExpectedResult.class), new Object[] { java.util.Objects.requireNonNull(expected, "expected is required") });
    }

    /**
     * (experimental) The actual results must match exactly.
     * <p>
     * Missing data
     * will result in a failure
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // actual results
     * Map&lt;String, Object&gt; actual = Map.of(
     *         "stringParam", "hello",
     *         "numberParam", 3,
     *         "booleanParam", true);
     * // pass
     * ExpectedResult.exact(Map.of(
     *         "stringParam", "hello",
     *         "numberParam", 3,
     *         "booleanParam", true));
     * // fail
     * ExpectedResult.exact(Map.of(
     *         "stringParam", "hello"));
     * </pre></blockquote>
     * <p>
     * @param expected This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.integtests.ExpectedResult exact(final @org.jetbrains.annotations.NotNull java.lang.Object expected) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.integtests.ExpectedResult.class, "exact", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.integtests.ExpectedResult.class), new Object[] { expected });
    }

    /**
     * (experimental) The expected results must be a subset of the actual results.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // actual results
     * Map&lt;String, Object&gt; actual = Map.of(
     *         "stringParam", "hello",
     *         "numberParam", 3,
     *         "booleanParam", true);
     * // pass
     * ExpectedResult.objectLike(Map.of(
     *         "stringParam", "hello"));
     * </pre></blockquote>
     * <p>
     * @param expected This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.integtests.ExpectedResult objectLike(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, ? extends java.lang.Object> expected) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.integtests.ExpectedResult.class, "objectLike", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.integtests.ExpectedResult.class), new Object[] { java.util.Objects.requireNonNull(expected, "expected is required") });
    }

    /**
     * (experimental) Actual results is a string that matches the Expected result regex.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // actual results
     * String actual = "some string value";
     * // pass
     * ExpectedResult.stringLikeRegexp("value");
     * </pre></blockquote>
     * <p>
     * @param expected This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.integtests.ExpectedResult stringLikeRegexp(final @org.jetbrains.annotations.NotNull java.lang.String expected) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.integtests.ExpectedResult.class, "stringLikeRegexp", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.integtests.ExpectedResult.class), new Object[] { java.util.Objects.requireNonNull(expected, "expected is required") });
    }

    /**
     * (experimental) The expected results encoded as a string.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public abstract @org.jetbrains.annotations.NotNull java.lang.String getResult();

    /**
     * (experimental) The expected results encoded as a string.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public abstract void setResult(final @org.jetbrains.annotations.NotNull java.lang.String value);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.integtests.ExpectedResult {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * (experimental) The expected results encoded as a string.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public final @org.jetbrains.annotations.NotNull java.lang.String getResult() {
            return software.amazon.jsii.Kernel.get(this, "result", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * (experimental) The expected results encoded as a string.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public final void setResult(final @org.jetbrains.annotations.NotNull java.lang.String value) {
            software.amazon.jsii.Kernel.set(this, "result", java.util.Objects.requireNonNull(value, "result is required"));
        }
    }
}
