package software.amazon.awscdk.core;

/**
 * (experimental) Possible values for a resource's Removal Policy.
 * <p>
 * The removal policy controls what happens to the resource if it stops being
 * managed by CloudFormation. This can happen in one of three situations:
 * <p>
 * <ul>
 * <li>The resource is removed from the template, so CloudFormation stops managing it;</li>
 * <li>A change to the resource is made that requires it to be replaced, so CloudFormation stops
 * managing it;</li>
 * <li>The stack is deleted, so CloudFormation stops managing all resources in it.</li>
 * </ul>
 * <p>
 * The Removal Policy applies to all above cases.
 * <p>
 * Many stateful resources in the AWS Construct Library will accept a
 * <code>removalPolicy</code> as a property, typically defaulting it to <code>RETAIN</code>.
 * <p>
 * If the AWS Construct Library resource does not accept a <code>removalPolicy</code>
 * argument, you can always configure it by using the escape hatch mechanism,
 * as shown in the following example:
 * <p>
 * <blockquote><pre>
 * Bucket bucket;
 * CfnResource cfnBucket = (CfnResource)bucket.node.findChild("Resource");
 * cfnBucket.applyRemovalPolicy(RemovalPolicy.DESTROY);
 * </pre></blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.core.*;
 * GraphqlApi api;
 * User user = new User(this, "User");
 * Domain domain = Domain.Builder.create(this, "Domain")
 *         .version(EngineVersion.OPENSEARCH_1_2)
 *         .removalPolicy(RemovalPolicy.DESTROY)
 *         .fineGrainedAccessControl(AdvancedSecurityOptions.builder().masterUserArn(user.getUserArn()).build())
 *         .encryptionAtRest(EncryptionAtRestOptions.builder().enabled(true).build())
 *         .nodeToNodeEncryption(true)
 *         .enforceHttps(true)
 *         .build();
 * OpenSearchDataSource ds = api.addOpenSearchDataSource("ds", domain);
 * ds.createResolver(BaseResolverProps.builder()
 *         .typeName("Query")
 *         .fieldName("getTests")
 *         .requestMappingTemplate(MappingTemplate.fromString(JSON.stringify(Map.of(
 *                 "version", "2017-02-28",
 *                 "operation", "GET",
 *                 "path", "/id/post/_search",
 *                 "params", Map.of(
 *                         "headers", Map.of(),
 *                         "queryString", Map.of(),
 *                         "body", Map.of("from", 0, "size", 50))))))
 *         .responseMappingTemplate(MappingTemplate.fromString("[\n    #foreach($entry in $context.result.hits.hits)\n    #if( $velocityCount &gt; 1 ) , #end\n    $utils.toJson($entry.get(\"_source\"))\n    #end\n  ]"))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:51.524Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.RemovalPolicy")
public enum RemovalPolicy {
    /**
     * (experimental) This is the default removal policy.
     * <p>
     * It means that when the resource is
     * removed from the app, it will be physically destroyed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    DESTROY,
    /**
     * (experimental) This uses the 'Retain' DeletionPolicy, which will cause the resource to be retained in the account, but orphaned from the stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    RETAIN,
    /**
     * (experimental) This retention policy deletes the resource, but saves a snapshot of its data before deleting, so that it can be re-created later.
     * <p>
     * Only available for some stateful resources,
     * like databases, EFS volumes, etc.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-deletionpolicy.html#aws-attribute-deletionpolicy-options">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-deletionpolicy.html#aws-attribute-deletionpolicy-options</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    SNAPSHOT,
}
