package software.amazon.awscdk.core;

/**
 * (experimental) Represents a date of expiration.
 * <p>
 * The amount can be specified either as a Date object, timestamp, Duration or string.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.core.*;
 * Duration duration;
 * Expiration expiration = Expiration.after(duration);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:51.477Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.Expiration")
public class Expiration extends software.amazon.jsii.JsiiObject {

    protected Expiration(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Expiration(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * (experimental) Expire once the specified duration has passed since deployment time.
     * <p>
     * @param t the duration to wait before expiring. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Expiration after(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Duration t) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Expiration.class, "after", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Expiration.class), new Object[] { java.util.Objects.requireNonNull(t, "t is required") });
    }

    /**
     * (experimental) Expire at the specified date.
     * <p>
     * @param d date to expire at. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Expiration atDate(final @org.jetbrains.annotations.NotNull java.time.Instant d) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Expiration.class, "atDate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Expiration.class), new Object[] { java.util.Objects.requireNonNull(d, "d is required") });
    }

    /**
     * (experimental) Expire at the specified timestamp.
     * <p>
     * @param t timestamp in unix milliseconds. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Expiration atTimestamp(final @org.jetbrains.annotations.NotNull java.lang.Number t) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Expiration.class, "atTimestamp", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Expiration.class), new Object[] { java.util.Objects.requireNonNull(t, "t is required") });
    }

    /**
     * (experimental) Expire at specified date, represented as a string.
     * <p>
     * @param s the string that represents date to expire at. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Expiration fromString(final @org.jetbrains.annotations.NotNull java.lang.String s) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.core.Expiration.class, "fromString", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Expiration.class), new Object[] { java.util.Objects.requireNonNull(s, "s is required") });
    }

    /**
     * (experimental) Check if Exipiration expires after input.
     * <p>
     * @param t the duration to check against. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean isAfter(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Duration t) {
        return software.amazon.jsii.Kernel.call(this, "isAfter", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { java.util.Objects.requireNonNull(t, "t is required") });
    }

    /**
     * (experimental) Check if Exipiration expires before input.
     * <p>
     * @param t the duration to check against. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean isBefore(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Duration t) {
        return software.amazon.jsii.Kernel.call(this, "isBefore", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { java.util.Objects.requireNonNull(t, "t is required") });
    }

    /**
     * (experimental) Exipration Value in a formatted Unix Epoch Time in seconds.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.Number toEpoch() {
        return software.amazon.jsii.Kernel.call(this, "toEpoch", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * (experimental) Expiration value as a Date object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.time.Instant getDate() {
        return software.amazon.jsii.Kernel.get(this, "date", software.amazon.jsii.NativeType.forClass(java.time.Instant.class));
    }
}
