package software.amazon.awscdk.core;

/**
 * A CloudFormation `AWS::CloudFormation::HookTypeConfig`.
 * <p>
 * The <code>HookTypeConfig</code> resource specifies the configuration of a hook.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.core.*;
 * CfnHookTypeConfig cfnHookTypeConfig = CfnHookTypeConfig.Builder.create(this, "MyCfnHookTypeConfig")
 *         .configuration("configuration")
 *         // the properties below are optional
 *         .configurationAlias("configurationAlias")
 *         .typeArn("typeArn")
 *         .typeName("typeName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:51.280Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.CfnHookTypeConfig")
public class CfnHookTypeConfig extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnHookTypeConfig(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnHookTypeConfig(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.core.CfnHookTypeConfig.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::CloudFormation::HookTypeConfig`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnHookTypeConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.CfnHookTypeConfigProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Number (ARN) of the activated hook type configuration, in this account and Region.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrConfigurationArn() {
        return software.amazon.jsii.Kernel.get(this, "attrConfigurationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Specifies the activated hook type configuration, in this AWS account and AWS Region .
     * <p>
     * You must specify either <code>TypeName</code> and <code>Configuration</code> or <code>TypeARN</code> and <code>Configuration</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "configuration", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the activated hook type configuration, in this AWS account and AWS Region .
     * <p>
     * You must specify either <code>TypeName</code> and <code>Configuration</code> or <code>TypeARN</code> and <code>Configuration</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfiguration(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "configuration", java.util.Objects.requireNonNull(value, "configuration is required"));
    }

    /**
     * Specifies the activated hook type configuration, in this AWS account and AWS Region .
     * <p>
     * Defaults to <code>default</code> alias. Hook types currently support default configuration alias.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getConfigurationAlias() {
        return software.amazon.jsii.Kernel.get(this, "configurationAlias", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the activated hook type configuration, in this AWS account and AWS Region .
     * <p>
     * Defaults to <code>default</code> alias. Hook types currently support default configuration alias.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfigurationAlias(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "configurationAlias", value);
    }

    /**
     * The Amazon Resource Number (ARN) for the hook to set `Configuration` for.
     * <p>
     * You must specify either <code>TypeName</code> and <code>Configuration</code> or <code>TypeARN</code> and <code>Configuration</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTypeArn() {
        return software.amazon.jsii.Kernel.get(this, "typeArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Number (ARN) for the hook to set `Configuration` for.
     * <p>
     * You must specify either <code>TypeName</code> and <code>Configuration</code> or <code>TypeARN</code> and <code>Configuration</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTypeArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "typeArn", value);
    }

    /**
     * The unique name for your hook.
     * <p>
     * Specifies a three-part namespace for your hook, with a recommended pattern of <code>Organization::Service::Hook</code> .
     * <p>
     * You must specify either <code>TypeName</code> and <code>Configuration</code> or <code>TypeARN</code> and <code>Configuration</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTypeName() {
        return software.amazon.jsii.Kernel.get(this, "typeName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique name for your hook.
     * <p>
     * Specifies a three-part namespace for your hook, with a recommended pattern of <code>Organization::Service::Hook</code> .
     * <p>
     * You must specify either <code>TypeName</code> and <code>Configuration</code> or <code>TypeARN</code> and <code>Configuration</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTypeName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "typeName", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.core.CfnHookTypeConfig}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.core.CfnHookTypeConfig> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.core.CfnHookTypeConfigProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.core.CfnHookTypeConfigProps.Builder();
        }

        /**
         * Specifies the activated hook type configuration, in this AWS account and AWS Region .
         * <p>
         * You must specify either <code>TypeName</code> and <code>Configuration</code> or <code>TypeARN</code> and <code>Configuration</code> .
         * <p>
         * @return {@code this}
         * @param configuration Specifies the activated hook type configuration, in this AWS account and AWS Region . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuration(final java.lang.String configuration) {
            this.props.configuration(configuration);
            return this;
        }

        /**
         * Specifies the activated hook type configuration, in this AWS account and AWS Region .
         * <p>
         * Defaults to <code>default</code> alias. Hook types currently support default configuration alias.
         * <p>
         * @return {@code this}
         * @param configurationAlias Specifies the activated hook type configuration, in this AWS account and AWS Region . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configurationAlias(final java.lang.String configurationAlias) {
            this.props.configurationAlias(configurationAlias);
            return this;
        }

        /**
         * The Amazon Resource Number (ARN) for the hook to set `Configuration` for.
         * <p>
         * You must specify either <code>TypeName</code> and <code>Configuration</code> or <code>TypeARN</code> and <code>Configuration</code> .
         * <p>
         * @return {@code this}
         * @param typeArn The Amazon Resource Number (ARN) for the hook to set `Configuration` for. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder typeArn(final java.lang.String typeArn) {
            this.props.typeArn(typeArn);
            return this;
        }

        /**
         * The unique name for your hook.
         * <p>
         * Specifies a three-part namespace for your hook, with a recommended pattern of <code>Organization::Service::Hook</code> .
         * <p>
         * You must specify either <code>TypeName</code> and <code>Configuration</code> or <code>TypeARN</code> and <code>Configuration</code> .
         * <p>
         * @return {@code this}
         * @param typeName The unique name for your hook. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder typeName(final java.lang.String typeName) {
            this.props.typeName(typeName);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.core.CfnHookTypeConfig}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.core.CfnHookTypeConfig build() {
            return new software.amazon.awscdk.core.CfnHookTypeConfig(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
