package software.amazon.awscdk.appdelivery;

/**
 * (experimental) A class to deploy a stack that is part of a CDK App, using CodePipeline.
 * <p>
 * This composite Action takes care of preparing and executing a CloudFormation ChangeSet.
 * <p>
 * It currently does <em>not</em> support stacks that make use of <code>Asset</code>s, and
 * requires the deployed stack is in the same account and region where the
 * CodePipeline is hosted.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated from non-compiling source. May contain errors.
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.core.*;
 * import software.amazon.awscdk.core.*;
 * public class MyServiceStackA extends Stack {
 * }
 * public class MyServiceStackB extends Stack {
 * }
 * App app = new App();
 * // We define a stack that contains the CodePipeline
 * Stack pipelineStack = new Stack(app, "PipelineStack");
 * Pipeline pipeline = Pipeline.Builder.create(pipelineStack, "CodePipeline")
 *         // Mutating a CodePipeline can cause the currently propagating state to be
 *         // "lost". Ensure we re-run the latest change through the pipeline after it's
 *         // been mutated so we're sure the latest state is fully deployed through.
 *         .restartExecutionOnUpdate(true)
 *         .build();
 * // Configure the CodePipeline source - where your CDK App's source code is hosted
 * Artifact sourceOutput = new Artifact();
 * GitHubSourceAction source = GitHubSourceAction.Builder.create()
 *         .actionName("GitHub")
 *         .output(sourceOutput)
 *         .owner("myName")
 *         .repo("myRepo")
 *         .oauthToken(SecretValue.unsafePlainText("secret"))
 *         .build();
 * pipeline.addStage(StageOptions.builder()
 *         .stageName("source")
 *         .actions(List.of(source))
 *         .build());
 * PipelineProject project = PipelineProject.Builder.create(pipelineStack, "CodeBuild").build();
 * Artifact synthesizedApp = new Artifact();
 * CodeBuildAction buildAction = CodeBuildAction.Builder.create()
 *         .actionName("CodeBuild")
 *         .project(project)
 *         .input(sourceOutput)
 *         .outputs(List.of(synthesizedApp))
 *         .build();
 * pipeline.addStage(StageOptions.builder()
 *         .stageName("build")
 *         .actions(List.of(buildAction))
 *         .build());
 * // Optionally, self-update the pipeline stack
 * IStage selfUpdateStage = pipeline.addStage(StageOptions.builder().stageName("SelfUpdate").build());
 * selfUpdateStage.addAction(PipelineDeployStackAction.Builder.create()
 *         .stack(pipelineStack)
 *         .input(synthesizedApp)
 *         .adminPermissions(true)
 *         .build());
 * // Now add our service stacks
 * IStage deployStage = pipeline.addStage(StageOptions.builder().stageName("Deploy").build());
 * MyServiceStackA serviceStackA = MyServiceStackA.Builder.create(app, "ServiceStackA").build();
 * // Add actions to deploy the stacks in the deploy stage:
 * PipelineDeployStackAction deployServiceAAction = PipelineDeployStackAction.Builder.create()
 *         .stack(serviceStackA)
 *         .input(synthesizedApp)
 *         // See the note below for details about this option.
 *         .adminPermissions(false)
 *         .build();
 * deployStage.addAction(deployServiceAAction);
 * // Add the necessary permissions for you service deploy action. This role is
 * // is passed to CloudFormation and needs the permissions necessary to deploy
 * // stack. Alternatively you can enable [Administrator](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_job-functions.html#jf_administrator) permissions above,
 * // users should understand the privileged nature of this role.
 * String myResourceArn = "arn:partition:service:region:account-id:resource-id";
 * deployServiceAAction.addToDeploymentRolePolicy(PolicyStatement.Builder.create()
 *         .actions(List.of("service:SomeAction"))
 *         .resources(List.of(myResourceArn))
 *         .build());
 * MyServiceStackB serviceStackB = MyServiceStackB.Builder.create(app, "ServiceStackB").build();
 * deployStage.addAction(PipelineDeployStackAction.Builder.create()
 *         .stack(serviceStackB)
 *         .input(synthesizedApp)
 *         .createChangeSetRunOrder(998)
 *         .adminPermissions(true)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.72.0 (build 4b8828b)", date = "2022-12-27T20:28:51.608Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.core.$Module.class, fqn = "monocdk.app_delivery.PipelineDeployStackAction")
public class PipelineDeployStackAction extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codepipeline.IAction {

    protected PipelineDeployStackAction(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected PipelineDeployStackAction(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public PipelineDeployStackAction(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.appdelivery.PipelineDeployStackActionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Add policy statements to the role deploying the stack.
     * <p>
     * This role is passed to CloudFormation and must have the IAM permissions
     * necessary to deploy the stack or you can grant this role <code>adminPermissions</code>
     * by using that option during creation. If you do not grant
     * <code>adminPermissions</code> you need to identify the proper statements to add to
     * this role based on the CloudFormation Resources in your stack.
     * <p>
     * @param statement This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addToDeploymentRolePolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement statement) {
        software.amazon.jsii.Kernel.call(this, "addToDeploymentRolePolicy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(statement, "statement is required") });
    }

    /**
     * (experimental) The callback invoked when this Action is added to a Pipeline.
     * <p>
     * @param scope This parameter is required.
     * @param stage This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.ActionConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.IStage stage, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.ActionBindOptions options) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.ActionConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(stage, "stage is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * (experimental) Creates an Event that will be triggered whenever the state of this Action changes.
     * <p>
     * @param name This parameter is required.
     * @param target
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onStateChange(final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.IRuleTarget target, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.RuleProps options) {
        return software.amazon.jsii.Kernel.call(this, "onStateChange", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(name, "name is required"), target, options });
    }

    /**
     * (experimental) Creates an Event that will be triggered whenever the state of this Action changes.
     * <p>
     * @param name This parameter is required.
     * @param target
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onStateChange(final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.IRuleTarget target) {
        return software.amazon.jsii.Kernel.call(this, "onStateChange", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(name, "name is required"), target });
    }

    /**
     * (experimental) Creates an Event that will be triggered whenever the state of this Action changes.
     * <p>
     * @param name This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onStateChange(final @org.jetbrains.annotations.NotNull java.lang.String name) {
        return software.amazon.jsii.Kernel.call(this, "onStateChange", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(name, "name is required") });
    }

    /**
     * (experimental) The simple properties of the Action, like its Owner, name, etc.
     * <p>
     * Note that this accessor will be called before the {&#64;link bind} callback.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.ActionProperties getActionProperties() {
        return software.amazon.jsii.Kernel.get(this, "actionProperties", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.ActionProperties.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole getDeploymentRole() {
        return software.amazon.jsii.Kernel.get(this, "deploymentRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.appdelivery.PipelineDeployStackAction}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.appdelivery.PipelineDeployStackAction> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.appdelivery.PipelineDeployStackActionProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.appdelivery.PipelineDeployStackActionProps.Builder();
        }

        /**
         * (experimental) Whether to grant admin permissions to CloudFormation while deploying this template.
         * <p>
         * Setting this to <code>true</code> affects the defaults for <code>role</code> and <code>capabilities</code>, if you
         * don't specify any alternatives.
         * <p>
         * The default role that will be created for you will have admin (i.e., <code>*</code>)
         * permissions on all resources, and the deployment will have named IAM
         * capabilities (i.e., able to create all IAM resources).
         * <p>
         * This is a shorthand that you can use if you fully trust the templates that
         * are deployed in this pipeline. If you want more fine-grained permissions,
         * use <code>addToRolePolicy</code> and <code>capabilities</code> to control what the CloudFormation
         * deployment is allowed to do.
         * <p>
         * @return {@code this}
         * @param adminPermissions Whether to grant admin permissions to CloudFormation while deploying this template. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder adminPermissions(final java.lang.Boolean adminPermissions) {
            this.props.adminPermissions(adminPermissions);
            return this;
        }

        /**
         * (experimental) The CodePipeline artifact that holds the synthesized app, which is the contents of the ``<directory>`` when running ``cdk synth -o <directory>``.
         * <p>
         * @return {@code this}
         * @param input The CodePipeline artifact that holds the synthesized app, which is the contents of the ``<directory>`` when running ``cdk synth -o <directory>``. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder input(final software.amazon.awscdk.services.codepipeline.Artifact input) {
            this.props.input(input);
            return this;
        }

        /**
         * (experimental) The CDK stack to be deployed.
         * <p>
         * @return {@code this}
         * @param stack The CDK stack to be deployed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder stack(final software.amazon.awscdk.core.Stack stack) {
            this.props.stack(stack);
            return this;
        }

        /**
         * (experimental) Acknowledge certain changes made as part of deployment.
         * <p>
         * For stacks that contain certain resources, explicit acknowledgement that AWS CloudFormation
         * might create or update those resources. For example, you must specify AnonymousIAM if your
         * stack template contains AWS Identity and Access Management (IAM) resources. For more
         * information
         * <p>
         * Default: [AnonymousIAM, AutoExpand], unless `adminPermissions` is true
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#using-iam-capabilities">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#using-iam-capabilities</a>
         * @param capabilities Acknowledge certain changes made as part of deployment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder capabilities(final java.util.List<? extends software.amazon.awscdk.services.cloudformation.CloudFormationCapabilities> capabilities) {
            this.props.capabilities(capabilities);
            return this;
        }

        /**
         * (experimental) The name to use when creating a ChangeSet for the stack.
         * <p>
         * Default: CDK-CodePipeline-ChangeSet
         * <p>
         * @return {@code this}
         * @param changeSetName The name to use when creating a ChangeSet for the stack. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder changeSetName(final java.lang.String changeSetName) {
            this.props.changeSetName(changeSetName);
            return this;
        }

        /**
         * (experimental) The name of the CodePipeline action creating the ChangeSet.
         * <p>
         * Default: 'ChangeSet'
         * <p>
         * @return {@code this}
         * @param createChangeSetActionName The name of the CodePipeline action creating the ChangeSet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder createChangeSetActionName(final java.lang.String createChangeSetActionName) {
            this.props.createChangeSetActionName(createChangeSetActionName);
            return this;
        }

        /**
         * (experimental) The runOrder for the CodePipeline action creating the ChangeSet.
         * <p>
         * Default: 1
         * <p>
         * @return {@code this}
         * @param createChangeSetRunOrder The runOrder for the CodePipeline action creating the ChangeSet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder createChangeSetRunOrder(final java.lang.Number createChangeSetRunOrder) {
            this.props.createChangeSetRunOrder(createChangeSetRunOrder);
            return this;
        }

        /**
         * (experimental) The name of the CodePipeline action creating the ChangeSet.
         * <p>
         * Default: 'Execute'
         * <p>
         * @return {@code this}
         * @param executeChangeSetActionName The name of the CodePipeline action creating the ChangeSet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder executeChangeSetActionName(final java.lang.String executeChangeSetActionName) {
            this.props.executeChangeSetActionName(executeChangeSetActionName);
            return this;
        }

        /**
         * (experimental) The runOrder for the CodePipeline action executing the ChangeSet.
         * <p>
         * Default: ``createChangeSetRunOrder + 1``
         * <p>
         * @return {@code this}
         * @param executeChangeSetRunOrder The runOrder for the CodePipeline action executing the ChangeSet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder executeChangeSetRunOrder(final java.lang.Number executeChangeSetRunOrder) {
            this.props.executeChangeSetRunOrder(executeChangeSetRunOrder);
            return this;
        }

        /**
         * (experimental) IAM role to assume when deploying changes.
         * <p>
         * If not specified, a fresh role is created. The role is created with zero
         * permissions unless <code>adminPermissions</code> is true, in which case the role will have
         * admin permissions.
         * <p>
         * Default: A fresh role with admin or no permissions (depending on the value of `adminPermissions`).
         * <p>
         * @return {@code this}
         * @param role IAM role to assume when deploying changes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props.role(role);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.appdelivery.PipelineDeployStackAction}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.appdelivery.PipelineDeployStackAction build() {
            return new software.amazon.awscdk.appdelivery.PipelineDeployStackAction(
                this.props.build()
            );
        }
    }
}
