/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.lambda;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.lambda.;
import software.amazon.awscdk.services.lambda.CfnLayerVersion;
import software.amazon.awscdk.services.lambda.CfnLayerVersionProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-lambda.CfnLayerVersion")
public class CfnLayerVersion
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnLayerVersion.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnLayerVersion(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnLayerVersion(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnLayerVersion(@NotNull Construct scope, @NotNull String id, @NotNull CfnLayerVersionProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)((Object)this), (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)((Object)this), (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)((Object)this), (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public Object getContent() {
        return Kernel.get((Object)((Object)this), (String)"content", (NativeType)NativeType.forClass(Object.class));
    }

    public void setContent(@NotNull IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"content", (Object)Objects.requireNonNull(value, "content is required"));
    }

    public void setContent(@NotNull ContentProperty value) {
        Kernel.set((Object)((Object)this), (String)"content", (Object)Objects.requireNonNull(value, "content is required"));
    }

    @Nullable
    public List<String> getCompatibleArchitectures() {
        return Optional.ofNullable((List)Kernel.get((Object)((Object)this), (String)"compatibleArchitectures", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setCompatibleArchitectures(@Nullable List<String> value) {
        Kernel.set((Object)((Object)this), (String)"compatibleArchitectures", value);
    }

    @Nullable
    public List<String> getCompatibleRuntimes() {
        return Optional.ofNullable((List)Kernel.get((Object)((Object)this), (String)"compatibleRuntimes", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setCompatibleRuntimes(@Nullable List<String> value) {
        Kernel.set((Object)((Object)this), (String)"compatibleRuntimes", value);
    }

    @Nullable
    public String getDescription() {
        return (String)Kernel.get((Object)((Object)this), (String)"description", (NativeType)NativeType.forClass(String.class));
    }

    public void setDescription(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"description", (Object)value);
    }

    @Nullable
    public String getLayerName() {
        return (String)Kernel.get((Object)((Object)this), (String)"layerName", (NativeType)NativeType.forClass(String.class));
    }

    public void setLayerName(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"layerName", (Object)value);
    }

    @Nullable
    public String getLicenseInfo() {
        return (String)Kernel.get((Object)((Object)this), (String)"licenseInfo", (NativeType)NativeType.forClass(String.class));
    }

    public void setLicenseInfo(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"licenseInfo", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnLayerVersion> {
        private final Construct scope;
        private final String id;
        private final CfnLayerVersionProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnLayerVersionProps.Builder();
        }

        public Builder content(IResolvable content) {
            this.props.content(content);
            return this;
        }

        public Builder content(ContentProperty content) {
            this.props.content(content);
            return this;
        }

        public Builder compatibleArchitectures(List<String> compatibleArchitectures) {
            this.props.compatibleArchitectures(compatibleArchitectures);
            return this;
        }

        public Builder compatibleRuntimes(List<String> compatibleRuntimes) {
            this.props.compatibleRuntimes(compatibleRuntimes);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder layerName(String layerName) {
            this.props.layerName(layerName);
            return this;
        }

        public Builder licenseInfo(String licenseInfo) {
            this.props.licenseInfo(licenseInfo);
            return this;
        }

        public CfnLayerVersion build() {
            return new CfnLayerVersion(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-lambda.CfnLayerVersion.ContentProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ContentProperty
    extends JsiiSerializable {
        @NotNull
        public String getS3Bucket();

        @NotNull
        public String getS3Key();

        @Nullable
        default public String getS3ObjectVersion() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ContentProperty> {
            String s3Bucket;
            String s3Key;
            String s3ObjectVersion;

            public Builder s3Bucket(String s3Bucket) {
                this.s3Bucket = s3Bucket;
                return this;
            }

            public Builder s3Key(String s3Key) {
                this.s3Key = s3Key;
                return this;
            }

            public Builder s3ObjectVersion(String s3ObjectVersion) {
                this.s3ObjectVersion = s3ObjectVersion;
                return this;
            }

            public ContentProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

