/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.lambda;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.services.lambda.;
import software.amazon.awscdk.services.lambda.EventSourceMappingOptions;
import software.amazon.awscdk.services.lambda.EventSourceMappingProps;
import software.amazon.awscdk.services.lambda.IEventSourceDlq;
import software.amazon.awscdk.services.lambda.IFunction;
import software.amazon.awscdk.services.lambda.SourceAccessConfiguration;
import software.amazon.awscdk.services.lambda.StartingPosition;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-lambda.EventSourceMappingProps")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface EventSourceMappingProps
extends JsiiSerializable,
EventSourceMappingOptions {
    @NotNull
    public IFunction getTarget();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<EventSourceMappingProps> {
        private IFunction target;
        private Number batchSize;
        private Boolean bisectBatchOnError;
        private Boolean enabled;
        private String eventSourceArn;
        private List<String> kafkaBootstrapServers;
        private String kafkaTopic;
        private Duration maxBatchingWindow;
        private Duration maxRecordAge;
        private IEventSourceDlq onFailure;
        private Number parallelizationFactor;
        private Boolean reportBatchItemFailures;
        private Number retryAttempts;
        private List<SourceAccessConfiguration> sourceAccessConfigurations;
        private StartingPosition startingPosition;
        private Duration tumblingWindow;

        public Builder target(IFunction target) {
            this.target = target;
            return this;
        }

        public Builder batchSize(Number batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public Builder bisectBatchOnError(Boolean bisectBatchOnError) {
            this.bisectBatchOnError = bisectBatchOnError;
            return this;
        }

        public Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder eventSourceArn(String eventSourceArn) {
            this.eventSourceArn = eventSourceArn;
            return this;
        }

        public Builder kafkaBootstrapServers(List<String> kafkaBootstrapServers) {
            this.kafkaBootstrapServers = kafkaBootstrapServers;
            return this;
        }

        public Builder kafkaTopic(String kafkaTopic) {
            this.kafkaTopic = kafkaTopic;
            return this;
        }

        public Builder maxBatchingWindow(Duration maxBatchingWindow) {
            this.maxBatchingWindow = maxBatchingWindow;
            return this;
        }

        public Builder maxRecordAge(Duration maxRecordAge) {
            this.maxRecordAge = maxRecordAge;
            return this;
        }

        public Builder onFailure(IEventSourceDlq onFailure) {
            this.onFailure = onFailure;
            return this;
        }

        public Builder parallelizationFactor(Number parallelizationFactor) {
            this.parallelizationFactor = parallelizationFactor;
            return this;
        }

        public Builder reportBatchItemFailures(Boolean reportBatchItemFailures) {
            this.reportBatchItemFailures = reportBatchItemFailures;
            return this;
        }

        public Builder retryAttempts(Number retryAttempts) {
            this.retryAttempts = retryAttempts;
            return this;
        }

        public Builder sourceAccessConfigurations(List<? extends SourceAccessConfiguration> sourceAccessConfigurations) {
            this.sourceAccessConfigurations = sourceAccessConfigurations;
            return this;
        }

        public Builder startingPosition(StartingPosition startingPosition) {
            this.startingPosition = startingPosition;
            return this;
        }

        public Builder tumblingWindow(Duration tumblingWindow) {
            this.tumblingWindow = tumblingWindow;
            return this;
        }

        public EventSourceMappingProps build() {
            return new Jsii.Proxy(this.target, this.batchSize, this.bisectBatchOnError, this.enabled, this.eventSourceArn, this.kafkaBootstrapServers, this.kafkaTopic, this.maxBatchingWindow, this.maxRecordAge, this.onFailure, this.parallelizationFactor, this.reportBatchItemFailures, this.retryAttempts, this.sourceAccessConfigurations, this.startingPosition, this.tumblingWindow);
        }
    }
}

