/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.kinesis;

import software.amazon.awscdk.services.kinesis.StreamEncryption;
import software.amazon.awscdk.services.kinesis.StreamProps;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.jsii.JsiiSerializable;

public interface StreamProps
extends JsiiSerializable {
    public StreamEncryption getEncryption();

    public IKey getEncryptionKey();

    public Number getRetentionPeriodHours();

    public Number getShardCount();

    public String getStreamName();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private StreamEncryption encryption;
        private IKey encryptionKey;
        private Number retentionPeriodHours;
        private Number shardCount;
        private String streamName;

        public Builder encryption(StreamEncryption encryption) {
            this.encryption = encryption;
            return this;
        }

        public Builder encryptionKey(IKey encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        public Builder retentionPeriodHours(Number retentionPeriodHours) {
            this.retentionPeriodHours = retentionPeriodHours;
            return this;
        }

        public Builder shardCount(Number shardCount) {
            this.shardCount = shardCount;
            return this;
        }

        public Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public StreamProps build() {
            return new Jsii.Proxy(this.encryption, this.encryptionKey, this.retentionPeriodHours, this.shardCount, this.streamName, null);
        }
    }
}

