/**
 * <h2>Amazon Kinesis Construct Library</h2>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="Stability: Experimental" src="https://img.shields.io/badge/stability-Experimental-important.svg?style=for-the-badge">
 * <p>
 * <blockquote>
 * <p>
 * <strong>This is a <em>developer preview</em> (public beta) module. Releases might lack important features and might have
 * future breaking changes.</strong>
 * <p>
 * This API is still under active development and subject to non-backward
 * compatible changes or removal in any future version. Use of the API is not recommended in production
 * environments. Experimental APIs are not subject to the Semantic Versioning model.
 * <p>
 * </blockquote>
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * Define an unencrypted Kinesis stream.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * new Stream(this, "MyFirstStream");
 * </pre></blockquote>
 * <p>
 * <h3>Encryption</h3>
 * <p>
 * Define a KMS-encrypted stream:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var stream = Stream.Builder.create(this, "MyEncryptedStream")
 *         .encryption(StreamEncryption.getKms())
 *         .build();
 * 
 * // you can access the encryption key:
 * assert(stream.getEncryptionKey() instanceof kms.getKey());
 * </pre></blockquote>
 * <p>
 * You can also supply your own key:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var myKmsKey = new Key(this, "MyKey");
 * 
 * var stream = Stream.Builder.create(this, "MyEncryptedStream")
 *         .encryption(StreamEncryption.getKms())
 *         .encryptionKey(myKmsKey)
 *         .build();
 * 
 * assert(stream.getEncryptionKey() === myKmsKey);
 * </pre></blockquote>
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
package software.amazon.awscdk.services.kinesis;
