package software.amazon.awscdk.services.kinesis;

/**
 * Properties for a Kinesis Stream.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Key key = new Key(this, "MyKey");
 * Stream.Builder.create(this, "MyEncryptedStream")
 *         .encryption(StreamEncryption.KMS)
 *         .encryptionKey(key)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-03-02T14:17:20.247Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.kinesis.$Module.class, fqn = "@aws-cdk/aws-kinesis.StreamProps")
@software.amazon.jsii.Jsii.Proxy(StreamProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface StreamProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The kind of server-side encryption to apply to this stream.
     * <p>
     * If you choose KMS, you can specify a KMS key via <code>encryptionKey</code>. If
     * encryption key is not specified, a key will automatically be created.
     * <p>
     * Default: - StreamEncryption.KMS if encrypted Streams are supported in the region
     * or StreamEncryption.UNENCRYPTED otherwise.
     * StreamEncryption.KMS if an encryption key is supplied through the encryptionKey property
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesis.StreamEncryption getEncryption() {
        return null;
    }

    /**
     * External KMS key to use for stream encryption.
     * <p>
     * The 'encryption' property must be set to "Kms".
     * <p>
     * Default: - Kinesis Data Streams master key ('/alias/aws/kinesis').
     * If encryption is set to StreamEncryption.KMS and this property is undefined, a new KMS key
     * will be created and associated with this stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
        return null;
    }

    /**
     * The number of hours for the data records that are stored in shards to remain accessible.
     * <p>
     * Default: Duration.hours(24)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getRetentionPeriod() {
        return null;
    }

    /**
     * The number of shards for the stream.
     * <p>
     * Can only be provided if streamMode is Provisioned.
     * <p>
     * Default: 1
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getShardCount() {
        return null;
    }

    /**
     * The capacity mode of this stream.
     * <p>
     * Default: StreamMode.PROVISIONED
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesis.StreamMode getStreamMode() {
        return null;
    }

    /**
     * Enforces a particular physical stream name.
     * <p>
     * Default: <generated>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStreamName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link StreamProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link StreamProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<StreamProps> {
        software.amazon.awscdk.services.kinesis.StreamEncryption encryption;
        software.amazon.awscdk.services.kms.IKey encryptionKey;
        software.amazon.awscdk.core.Duration retentionPeriod;
        java.lang.Number shardCount;
        software.amazon.awscdk.services.kinesis.StreamMode streamMode;
        java.lang.String streamName;

        /**
         * Sets the value of {@link StreamProps#getEncryption}
         * @param encryption The kind of server-side encryption to apply to this stream.
         *                   If you choose KMS, you can specify a KMS key via <code>encryptionKey</code>. If
         *                   encryption key is not specified, a key will automatically be created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryption(software.amazon.awscdk.services.kinesis.StreamEncryption encryption) {
            this.encryption = encryption;
            return this;
        }

        /**
         * Sets the value of {@link StreamProps#getEncryptionKey}
         * @param encryptionKey External KMS key to use for stream encryption.
         *                      The 'encryption' property must be set to "Kms".
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionKey(software.amazon.awscdk.services.kms.IKey encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        /**
         * Sets the value of {@link StreamProps#getRetentionPeriod}
         * @param retentionPeriod The number of hours for the data records that are stored in shards to remain accessible.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retentionPeriod(software.amazon.awscdk.core.Duration retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        /**
         * Sets the value of {@link StreamProps#getShardCount}
         * @param shardCount The number of shards for the stream.
         *                   Can only be provided if streamMode is Provisioned.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder shardCount(java.lang.Number shardCount) {
            this.shardCount = shardCount;
            return this;
        }

        /**
         * Sets the value of {@link StreamProps#getStreamMode}
         * @param streamMode The capacity mode of this stream.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder streamMode(software.amazon.awscdk.services.kinesis.StreamMode streamMode) {
            this.streamMode = streamMode;
            return this;
        }

        /**
         * Sets the value of {@link StreamProps#getStreamName}
         * @param streamName Enforces a particular physical stream name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder streamName(java.lang.String streamName) {
            this.streamName = streamName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link StreamProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public StreamProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link StreamProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StreamProps {
        private final software.amazon.awscdk.services.kinesis.StreamEncryption encryption;
        private final software.amazon.awscdk.services.kms.IKey encryptionKey;
        private final software.amazon.awscdk.core.Duration retentionPeriod;
        private final java.lang.Number shardCount;
        private final software.amazon.awscdk.services.kinesis.StreamMode streamMode;
        private final java.lang.String streamName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.encryption = software.amazon.jsii.Kernel.get(this, "encryption", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesis.StreamEncryption.class));
            this.encryptionKey = software.amazon.jsii.Kernel.get(this, "encryptionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
            this.retentionPeriod = software.amazon.jsii.Kernel.get(this, "retentionPeriod", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
            this.shardCount = software.amazon.jsii.Kernel.get(this, "shardCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.streamMode = software.amazon.jsii.Kernel.get(this, "streamMode", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesis.StreamMode.class));
            this.streamName = software.amazon.jsii.Kernel.get(this, "streamName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.encryption = builder.encryption;
            this.encryptionKey = builder.encryptionKey;
            this.retentionPeriod = builder.retentionPeriod;
            this.shardCount = builder.shardCount;
            this.streamMode = builder.streamMode;
            this.streamName = builder.streamName;
        }

        @Override
        public final software.amazon.awscdk.services.kinesis.StreamEncryption getEncryption() {
            return this.encryption;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
            return this.encryptionKey;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getRetentionPeriod() {
            return this.retentionPeriod;
        }

        @Override
        public final java.lang.Number getShardCount() {
            return this.shardCount;
        }

        @Override
        public final software.amazon.awscdk.services.kinesis.StreamMode getStreamMode() {
            return this.streamMode;
        }

        @Override
        public final java.lang.String getStreamName() {
            return this.streamName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getEncryption() != null) {
                data.set("encryption", om.valueToTree(this.getEncryption()));
            }
            if (this.getEncryptionKey() != null) {
                data.set("encryptionKey", om.valueToTree(this.getEncryptionKey()));
            }
            if (this.getRetentionPeriod() != null) {
                data.set("retentionPeriod", om.valueToTree(this.getRetentionPeriod()));
            }
            if (this.getShardCount() != null) {
                data.set("shardCount", om.valueToTree(this.getShardCount()));
            }
            if (this.getStreamMode() != null) {
                data.set("streamMode", om.valueToTree(this.getStreamMode()));
            }
            if (this.getStreamName() != null) {
                data.set("streamName", om.valueToTree(this.getStreamName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-kinesis.StreamProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            StreamProps.Jsii$Proxy that = (StreamProps.Jsii$Proxy) o;

            if (this.encryption != null ? !this.encryption.equals(that.encryption) : that.encryption != null) return false;
            if (this.encryptionKey != null ? !this.encryptionKey.equals(that.encryptionKey) : that.encryptionKey != null) return false;
            if (this.retentionPeriod != null ? !this.retentionPeriod.equals(that.retentionPeriod) : that.retentionPeriod != null) return false;
            if (this.shardCount != null ? !this.shardCount.equals(that.shardCount) : that.shardCount != null) return false;
            if (this.streamMode != null ? !this.streamMode.equals(that.streamMode) : that.streamMode != null) return false;
            return this.streamName != null ? this.streamName.equals(that.streamName) : that.streamName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.encryption != null ? this.encryption.hashCode() : 0;
            result = 31 * result + (this.encryptionKey != null ? this.encryptionKey.hashCode() : 0);
            result = 31 * result + (this.retentionPeriod != null ? this.retentionPeriod.hashCode() : 0);
            result = 31 * result + (this.shardCount != null ? this.shardCount.hashCode() : 0);
            result = 31 * result + (this.streamMode != null ? this.streamMode.hashCode() : 0);
            result = 31 * result + (this.streamName != null ? this.streamName.hashCode() : 0);
            return result;
        }
    }
}
