package software.amazon.awscdk.services.kinesis;

/**
 * A reference to a stream.
 * 
 * The easiest way to instantiate is to call
 * `stream.export()`. Then, the consumer can use `Stream.import(this, ref)` and
 * get a `Stream`.
 * 
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.13.2 (build a2116e9)", date = "2019-07-01T17:00:33.111Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface StreamAttributes extends software.amazon.jsii.JsiiSerializable {
    /**
     * The ARN of the stream.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.String getStreamArn();
    /**
     * The KMS key securing the contents of the stream if encryption is enabled.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    software.amazon.awscdk.services.kms.IKey getEncryptionKey();

    /**
     * @return a {@link Builder} of {@link StreamAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link StreamAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Builder {
        private java.lang.String _streamArn;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.kms.IKey _encryptionKey;

        /**
         * Sets the value of StreamArn
         * @param value The ARN of the stream.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withStreamArn(final java.lang.String value) {
            this._streamArn = java.util.Objects.requireNonNull(value, "streamArn is required");
            return this;
        }
        /**
         * Sets the value of EncryptionKey
         * @param value The KMS key securing the contents of the stream if encryption is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withEncryptionKey(@javax.annotation.Nullable final software.amazon.awscdk.services.kms.IKey value) {
            this._encryptionKey = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link StreamAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public StreamAttributes build() {
            return new StreamAttributes() {
                private final java.lang.String $streamArn = java.util.Objects.requireNonNull(_streamArn, "streamArn is required");
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.kms.IKey $encryptionKey = _encryptionKey;

                @Override
                public java.lang.String getStreamArn() {
                    return this.$streamArn;
                }

                @Override
                public software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
                    return this.$encryptionKey;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("streamArn", om.valueToTree(this.getStreamArn()));
                    if (this.getEncryptionKey() != null) {
                        obj.set("encryptionKey", om.valueToTree(this.getEncryptionKey()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesis.StreamAttributes {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The ARN of the stream.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public java.lang.String getStreamArn() {
            return this.jsiiGet("streamArn", java.lang.String.class);
        }

        /**
         * The KMS key securing the contents of the stream if encryption is enabled.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
            return this.jsiiGet("encryptionKey", software.amazon.awscdk.services.kms.IKey.class);
        }
    }
}
