/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.eks;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.eks.;
import software.amazon.awscdk.services.eks.CfnCluster;
import software.amazon.awscdk.services.eks.CfnClusterProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-eks.CfnCluster")
public class CfnCluster
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnCluster.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnCluster(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnCluster(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnCluster(@NotNull Construct scope, @NotNull String id, @NotNull CfnClusterProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)((Object)this), (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)((Object)this), (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)Kernel.get((Object)((Object)this), (String)"attrArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrCertificateAuthorityData() {
        return (String)Kernel.get((Object)((Object)this), (String)"attrCertificateAuthorityData", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrClusterSecurityGroupId() {
        return (String)Kernel.get((Object)((Object)this), (String)"attrClusterSecurityGroupId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrEncryptionConfigKeyArn() {
        return (String)Kernel.get((Object)((Object)this), (String)"attrEncryptionConfigKeyArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrEndpoint() {
        return (String)Kernel.get((Object)((Object)this), (String)"attrEndpoint", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrOpenIdConnectIssuerUrl() {
        return (String)Kernel.get((Object)((Object)this), (String)"attrOpenIdConnectIssuerUrl", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)((Object)this), (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public Object getResourcesVpcConfig() {
        return Kernel.get((Object)((Object)this), (String)"resourcesVpcConfig", (NativeType)NativeType.forClass(Object.class));
    }

    public void setResourcesVpcConfig(@NotNull ResourcesVpcConfigProperty value) {
        Kernel.set((Object)((Object)this), (String)"resourcesVpcConfig", (Object)Objects.requireNonNull(value, "resourcesVpcConfig is required"));
    }

    public void setResourcesVpcConfig(@NotNull IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"resourcesVpcConfig", (Object)Objects.requireNonNull(value, "resourcesVpcConfig is required"));
    }

    @NotNull
    public String getRoleArn() {
        return (String)Kernel.get((Object)((Object)this), (String)"roleArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setRoleArn(@NotNull String value) {
        Kernel.set((Object)((Object)this), (String)"roleArn", (Object)Objects.requireNonNull(value, "roleArn is required"));
    }

    @Nullable
    public Object getEncryptionConfig() {
        return Kernel.get((Object)((Object)this), (String)"encryptionConfig", (NativeType)NativeType.forClass(Object.class));
    }

    public void setEncryptionConfig(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"encryptionConfig", (Object)value);
    }

    public void setEncryptionConfig(@Nullable List<Object> value) {
        Kernel.set((Object)((Object)this), (String)"encryptionConfig", value);
    }

    @Nullable
    public Object getKubernetesNetworkConfig() {
        return Kernel.get((Object)((Object)this), (String)"kubernetesNetworkConfig", (NativeType)NativeType.forClass(Object.class));
    }

    public void setKubernetesNetworkConfig(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"kubernetesNetworkConfig", (Object)value);
    }

    public void setKubernetesNetworkConfig(@Nullable KubernetesNetworkConfigProperty value) {
        Kernel.set((Object)((Object)this), (String)"kubernetesNetworkConfig", (Object)value);
    }

    @Nullable
    public String getName() {
        return (String)Kernel.get((Object)((Object)this), (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    public void setName(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"name", (Object)value);
    }

    @Nullable
    public String getVersion() {
        return (String)Kernel.get((Object)((Object)this), (String)"version", (NativeType)NativeType.forClass(String.class));
    }

    public void setVersion(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"version", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnCluster> {
        private final Construct scope;
        private final String id;
        private final CfnClusterProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnClusterProps.Builder();
        }

        public Builder resourcesVpcConfig(ResourcesVpcConfigProperty resourcesVpcConfig) {
            this.props.resourcesVpcConfig(resourcesVpcConfig);
            return this;
        }

        public Builder resourcesVpcConfig(IResolvable resourcesVpcConfig) {
            this.props.resourcesVpcConfig(resourcesVpcConfig);
            return this;
        }

        public Builder roleArn(String roleArn) {
            this.props.roleArn(roleArn);
            return this;
        }

        public Builder encryptionConfig(IResolvable encryptionConfig) {
            this.props.encryptionConfig(encryptionConfig);
            return this;
        }

        public Builder encryptionConfig(List<? extends Object> encryptionConfig) {
            this.props.encryptionConfig(encryptionConfig);
            return this;
        }

        public Builder kubernetesNetworkConfig(IResolvable kubernetesNetworkConfig) {
            this.props.kubernetesNetworkConfig(kubernetesNetworkConfig);
            return this;
        }

        public Builder kubernetesNetworkConfig(KubernetesNetworkConfigProperty kubernetesNetworkConfig) {
            this.props.kubernetesNetworkConfig(kubernetesNetworkConfig);
            return this;
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder version(String version) {
            this.props.version(version);
            return this;
        }

        public CfnCluster build() {
            return new CfnCluster(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-eks.CfnCluster.ResourcesVpcConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ResourcesVpcConfigProperty
    extends JsiiSerializable {
        @NotNull
        public List<String> getSubnetIds();

        @Nullable
        default public List<String> getSecurityGroupIds() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ResourcesVpcConfigProperty> {
            private List<String> subnetIds;
            private List<String> securityGroupIds;

            public Builder subnetIds(List<String> subnetIds) {
                this.subnetIds = subnetIds;
                return this;
            }

            public Builder securityGroupIds(List<String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            public ResourcesVpcConfigProperty build() {
                return new Jsii.Proxy(this.subnetIds, this.securityGroupIds);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-eks.CfnCluster.ProviderProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ProviderProperty
    extends JsiiSerializable {
        @Nullable
        default public String getKeyArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ProviderProperty> {
            private String keyArn;

            public Builder keyArn(String keyArn) {
                this.keyArn = keyArn;
                return this;
            }

            public ProviderProperty build() {
                return new Jsii.Proxy(this.keyArn);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-eks.CfnCluster.KubernetesNetworkConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface KubernetesNetworkConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public String getServiceIpv4Cidr() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<KubernetesNetworkConfigProperty> {
            private String serviceIpv4Cidr;

            public Builder serviceIpv4Cidr(String serviceIpv4Cidr) {
                this.serviceIpv4Cidr = serviceIpv4Cidr;
                return this;
            }

            public KubernetesNetworkConfigProperty build() {
                return new Jsii.Proxy(this.serviceIpv4Cidr);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-eks.CfnCluster.EncryptionConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EncryptionConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getProvider() {
            return null;
        }

        @Nullable
        default public List<String> getResources() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EncryptionConfigProperty> {
            private Object provider;
            private List<String> resources;

            public Builder provider(IResolvable provider) {
                this.provider = provider;
                return this;
            }

            public Builder provider(ProviderProperty provider) {
                this.provider = provider;
                return this;
            }

            public Builder resources(List<String> resources) {
                this.resources = resources;
                return this;
            }

            public EncryptionConfigProperty build() {
                return new Jsii.Proxy(this.provider, this.resources);
            }
        }
    }
}

