package software.amazon.awscdk.services.cognito;

/**
 * The set of standard attributes that can be marked as required or mutable.
 * <p>
 * @see https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html#cognito-user-pools-standard-attributes
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.24.0 (build b722f66)", date = "2021-03-11T13:46:52.486Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cognito.$Module.class, fqn = "@aws-cdk/aws-cognito.StandardAttributes")
@software.amazon.jsii.Jsii.Proxy(StandardAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface StandardAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     * The user's postal address.
     * <p>
     * Default: - see the defaults under `StandardAttribute`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.StandardAttribute getAddress() {
        return null;
    }

    /**
     * The user's birthday, represented as an ISO 8601:2004 format.
     * <p>
     * Default: - see the defaults under `StandardAttribute`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.StandardAttribute getBirthdate() {
        return null;
    }

    /**
     * The user's e-mail address, represented as an RFC 5322 [RFC5322] addr-spec.
     * <p>
     * Default: - see the defaults under `StandardAttribute`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.StandardAttribute getEmail() {
        return null;
    }

    /**
     * Whether the email address has been verified.
     * <p>
     * Default: - see the defaults under `StandardAttribute`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.StandardAttribute getEmailVerified() {
        return null;
    }

    /**
     * The surname or last name of the user.
     * <p>
     * Default: - see the defaults under `StandardAttribute`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.StandardAttribute getFamilyName() {
        return null;
    }

    /**
     * The user's full name in displayable form, including all name parts, titles and suffixes.
     * <p>
     * Default: - see the defaults under `StandardAttribute`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.StandardAttribute getFullname() {
        return null;
    }

    /**
     * The user's gender.
     * <p>
     * Default: - see the defaults under `StandardAttribute`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.StandardAttribute getGender() {
        return null;
    }

    /**
     * The user's first name or give name.
     * <p>
     * Default: - see the defaults under `StandardAttribute`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.StandardAttribute getGivenName() {
        return null;
    }

    /**
     * The time, the user's information was last updated.
     * <p>
     * Default: - see the defaults under `StandardAttribute`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.StandardAttribute getLastUpdateTime() {
        return null;
    }

    /**
     * The user's locale, represented as a BCP47 [RFC5646] language tag.
     * <p>
     * Default: - see the defaults under `StandardAttribute`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.StandardAttribute getLocale() {
        return null;
    }

    /**
     * The user's middle name.
     * <p>
     * Default: - see the defaults under `StandardAttribute`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.StandardAttribute getMiddleName() {
        return null;
    }

    /**
     * The user's nickname or casual name.
     * <p>
     * Default: - see the defaults under `StandardAttribute`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.StandardAttribute getNickname() {
        return null;
    }

    /**
     * The user's telephone number.
     * <p>
     * Default: - see the defaults under `StandardAttribute`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.StandardAttribute getPhoneNumber() {
        return null;
    }

    /**
     * Whether the phone number has been verified.
     * <p>
     * Default: - see the defaults under `StandardAttribute`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.StandardAttribute getPhoneNumberVerified() {
        return null;
    }

    /**
     * The user's preffered username, different from the immutable user name.
     * <p>
     * Default: - see the defaults under `StandardAttribute`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.StandardAttribute getPreferredUsername() {
        return null;
    }

    /**
     * The URL to the user's profile page.
     * <p>
     * Default: - see the defaults under `StandardAttribute`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.StandardAttribute getProfilePage() {
        return null;
    }

    /**
     * The URL to the user's profile picture.
     * <p>
     * Default: - see the defaults under `StandardAttribute`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.StandardAttribute getProfilePicture() {
        return null;
    }

    /**
     * The user's time zone.
     * <p>
     * Default: - see the defaults under `StandardAttribute`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.StandardAttribute getTimezone() {
        return null;
    }

    /**
     * The URL to the user's web page or blog.
     * <p>
     * Default: - see the defaults under `StandardAttribute`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.StandardAttribute getWebsite() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link StandardAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link StandardAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<StandardAttributes> {
        private software.amazon.awscdk.services.cognito.StandardAttribute address;
        private software.amazon.awscdk.services.cognito.StandardAttribute birthdate;
        private software.amazon.awscdk.services.cognito.StandardAttribute email;
        private software.amazon.awscdk.services.cognito.StandardAttribute emailVerified;
        private software.amazon.awscdk.services.cognito.StandardAttribute familyName;
        private software.amazon.awscdk.services.cognito.StandardAttribute fullname;
        private software.amazon.awscdk.services.cognito.StandardAttribute gender;
        private software.amazon.awscdk.services.cognito.StandardAttribute givenName;
        private software.amazon.awscdk.services.cognito.StandardAttribute lastUpdateTime;
        private software.amazon.awscdk.services.cognito.StandardAttribute locale;
        private software.amazon.awscdk.services.cognito.StandardAttribute middleName;
        private software.amazon.awscdk.services.cognito.StandardAttribute nickname;
        private software.amazon.awscdk.services.cognito.StandardAttribute phoneNumber;
        private software.amazon.awscdk.services.cognito.StandardAttribute phoneNumberVerified;
        private software.amazon.awscdk.services.cognito.StandardAttribute preferredUsername;
        private software.amazon.awscdk.services.cognito.StandardAttribute profilePage;
        private software.amazon.awscdk.services.cognito.StandardAttribute profilePicture;
        private software.amazon.awscdk.services.cognito.StandardAttribute timezone;
        private software.amazon.awscdk.services.cognito.StandardAttribute website;

        /**
         * Sets the value of {@link StandardAttributes#getAddress}
         * @param address The user's postal address.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder address(software.amazon.awscdk.services.cognito.StandardAttribute address) {
            this.address = address;
            return this;
        }

        /**
         * Sets the value of {@link StandardAttributes#getBirthdate}
         * @param birthdate The user's birthday, represented as an ISO 8601:2004 format.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder birthdate(software.amazon.awscdk.services.cognito.StandardAttribute birthdate) {
            this.birthdate = birthdate;
            return this;
        }

        /**
         * Sets the value of {@link StandardAttributes#getEmail}
         * @param email The user's e-mail address, represented as an RFC 5322 [RFC5322] addr-spec.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder email(software.amazon.awscdk.services.cognito.StandardAttribute email) {
            this.email = email;
            return this;
        }

        /**
         * Sets the value of {@link StandardAttributes#getEmailVerified}
         * @param emailVerified Whether the email address has been verified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder emailVerified(software.amazon.awscdk.services.cognito.StandardAttribute emailVerified) {
            this.emailVerified = emailVerified;
            return this;
        }

        /**
         * Sets the value of {@link StandardAttributes#getFamilyName}
         * @param familyName The surname or last name of the user.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder familyName(software.amazon.awscdk.services.cognito.StandardAttribute familyName) {
            this.familyName = familyName;
            return this;
        }

        /**
         * Sets the value of {@link StandardAttributes#getFullname}
         * @param fullname The user's full name in displayable form, including all name parts, titles and suffixes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fullname(software.amazon.awscdk.services.cognito.StandardAttribute fullname) {
            this.fullname = fullname;
            return this;
        }

        /**
         * Sets the value of {@link StandardAttributes#getGender}
         * @param gender The user's gender.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gender(software.amazon.awscdk.services.cognito.StandardAttribute gender) {
            this.gender = gender;
            return this;
        }

        /**
         * Sets the value of {@link StandardAttributes#getGivenName}
         * @param givenName The user's first name or give name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder givenName(software.amazon.awscdk.services.cognito.StandardAttribute givenName) {
            this.givenName = givenName;
            return this;
        }

        /**
         * Sets the value of {@link StandardAttributes#getLastUpdateTime}
         * @param lastUpdateTime The time, the user's information was last updated.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lastUpdateTime(software.amazon.awscdk.services.cognito.StandardAttribute lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        /**
         * Sets the value of {@link StandardAttributes#getLocale}
         * @param locale The user's locale, represented as a BCP47 [RFC5646] language tag.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder locale(software.amazon.awscdk.services.cognito.StandardAttribute locale) {
            this.locale = locale;
            return this;
        }

        /**
         * Sets the value of {@link StandardAttributes#getMiddleName}
         * @param middleName The user's middle name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder middleName(software.amazon.awscdk.services.cognito.StandardAttribute middleName) {
            this.middleName = middleName;
            return this;
        }

        /**
         * Sets the value of {@link StandardAttributes#getNickname}
         * @param nickname The user's nickname or casual name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nickname(software.amazon.awscdk.services.cognito.StandardAttribute nickname) {
            this.nickname = nickname;
            return this;
        }

        /**
         * Sets the value of {@link StandardAttributes#getPhoneNumber}
         * @param phoneNumber The user's telephone number.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder phoneNumber(software.amazon.awscdk.services.cognito.StandardAttribute phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        /**
         * Sets the value of {@link StandardAttributes#getPhoneNumberVerified}
         * @param phoneNumberVerified Whether the phone number has been verified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder phoneNumberVerified(software.amazon.awscdk.services.cognito.StandardAttribute phoneNumberVerified) {
            this.phoneNumberVerified = phoneNumberVerified;
            return this;
        }

        /**
         * Sets the value of {@link StandardAttributes#getPreferredUsername}
         * @param preferredUsername The user's preffered username, different from the immutable user name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preferredUsername(software.amazon.awscdk.services.cognito.StandardAttribute preferredUsername) {
            this.preferredUsername = preferredUsername;
            return this;
        }

        /**
         * Sets the value of {@link StandardAttributes#getProfilePage}
         * @param profilePage The URL to the user's profile page.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder profilePage(software.amazon.awscdk.services.cognito.StandardAttribute profilePage) {
            this.profilePage = profilePage;
            return this;
        }

        /**
         * Sets the value of {@link StandardAttributes#getProfilePicture}
         * @param profilePicture The URL to the user's profile picture.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder profilePicture(software.amazon.awscdk.services.cognito.StandardAttribute profilePicture) {
            this.profilePicture = profilePicture;
            return this;
        }

        /**
         * Sets the value of {@link StandardAttributes#getTimezone}
         * @param timezone The user's time zone.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timezone(software.amazon.awscdk.services.cognito.StandardAttribute timezone) {
            this.timezone = timezone;
            return this;
        }

        /**
         * Sets the value of {@link StandardAttributes#getWebsite}
         * @param website The URL to the user's web page or blog.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder website(software.amazon.awscdk.services.cognito.StandardAttribute website) {
            this.website = website;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link StandardAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public StandardAttributes build() {
            return new Jsii$Proxy(address, birthdate, email, emailVerified, familyName, fullname, gender, givenName, lastUpdateTime, locale, middleName, nickname, phoneNumber, phoneNumberVerified, preferredUsername, profilePage, profilePicture, timezone, website);
        }
    }

    /**
     * An implementation for {@link StandardAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StandardAttributes {
        private final software.amazon.awscdk.services.cognito.StandardAttribute address;
        private final software.amazon.awscdk.services.cognito.StandardAttribute birthdate;
        private final software.amazon.awscdk.services.cognito.StandardAttribute email;
        private final software.amazon.awscdk.services.cognito.StandardAttribute emailVerified;
        private final software.amazon.awscdk.services.cognito.StandardAttribute familyName;
        private final software.amazon.awscdk.services.cognito.StandardAttribute fullname;
        private final software.amazon.awscdk.services.cognito.StandardAttribute gender;
        private final software.amazon.awscdk.services.cognito.StandardAttribute givenName;
        private final software.amazon.awscdk.services.cognito.StandardAttribute lastUpdateTime;
        private final software.amazon.awscdk.services.cognito.StandardAttribute locale;
        private final software.amazon.awscdk.services.cognito.StandardAttribute middleName;
        private final software.amazon.awscdk.services.cognito.StandardAttribute nickname;
        private final software.amazon.awscdk.services.cognito.StandardAttribute phoneNumber;
        private final software.amazon.awscdk.services.cognito.StandardAttribute phoneNumberVerified;
        private final software.amazon.awscdk.services.cognito.StandardAttribute preferredUsername;
        private final software.amazon.awscdk.services.cognito.StandardAttribute profilePage;
        private final software.amazon.awscdk.services.cognito.StandardAttribute profilePicture;
        private final software.amazon.awscdk.services.cognito.StandardAttribute timezone;
        private final software.amazon.awscdk.services.cognito.StandardAttribute website;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.address = software.amazon.jsii.Kernel.get(this, "address", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.StandardAttribute.class));
            this.birthdate = software.amazon.jsii.Kernel.get(this, "birthdate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.StandardAttribute.class));
            this.email = software.amazon.jsii.Kernel.get(this, "email", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.StandardAttribute.class));
            this.emailVerified = software.amazon.jsii.Kernel.get(this, "emailVerified", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.StandardAttribute.class));
            this.familyName = software.amazon.jsii.Kernel.get(this, "familyName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.StandardAttribute.class));
            this.fullname = software.amazon.jsii.Kernel.get(this, "fullname", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.StandardAttribute.class));
            this.gender = software.amazon.jsii.Kernel.get(this, "gender", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.StandardAttribute.class));
            this.givenName = software.amazon.jsii.Kernel.get(this, "givenName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.StandardAttribute.class));
            this.lastUpdateTime = software.amazon.jsii.Kernel.get(this, "lastUpdateTime", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.StandardAttribute.class));
            this.locale = software.amazon.jsii.Kernel.get(this, "locale", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.StandardAttribute.class));
            this.middleName = software.amazon.jsii.Kernel.get(this, "middleName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.StandardAttribute.class));
            this.nickname = software.amazon.jsii.Kernel.get(this, "nickname", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.StandardAttribute.class));
            this.phoneNumber = software.amazon.jsii.Kernel.get(this, "phoneNumber", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.StandardAttribute.class));
            this.phoneNumberVerified = software.amazon.jsii.Kernel.get(this, "phoneNumberVerified", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.StandardAttribute.class));
            this.preferredUsername = software.amazon.jsii.Kernel.get(this, "preferredUsername", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.StandardAttribute.class));
            this.profilePage = software.amazon.jsii.Kernel.get(this, "profilePage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.StandardAttribute.class));
            this.profilePicture = software.amazon.jsii.Kernel.get(this, "profilePicture", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.StandardAttribute.class));
            this.timezone = software.amazon.jsii.Kernel.get(this, "timezone", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.StandardAttribute.class));
            this.website = software.amazon.jsii.Kernel.get(this, "website", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.StandardAttribute.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final software.amazon.awscdk.services.cognito.StandardAttribute address, final software.amazon.awscdk.services.cognito.StandardAttribute birthdate, final software.amazon.awscdk.services.cognito.StandardAttribute email, final software.amazon.awscdk.services.cognito.StandardAttribute emailVerified, final software.amazon.awscdk.services.cognito.StandardAttribute familyName, final software.amazon.awscdk.services.cognito.StandardAttribute fullname, final software.amazon.awscdk.services.cognito.StandardAttribute gender, final software.amazon.awscdk.services.cognito.StandardAttribute givenName, final software.amazon.awscdk.services.cognito.StandardAttribute lastUpdateTime, final software.amazon.awscdk.services.cognito.StandardAttribute locale, final software.amazon.awscdk.services.cognito.StandardAttribute middleName, final software.amazon.awscdk.services.cognito.StandardAttribute nickname, final software.amazon.awscdk.services.cognito.StandardAttribute phoneNumber, final software.amazon.awscdk.services.cognito.StandardAttribute phoneNumberVerified, final software.amazon.awscdk.services.cognito.StandardAttribute preferredUsername, final software.amazon.awscdk.services.cognito.StandardAttribute profilePage, final software.amazon.awscdk.services.cognito.StandardAttribute profilePicture, final software.amazon.awscdk.services.cognito.StandardAttribute timezone, final software.amazon.awscdk.services.cognito.StandardAttribute website) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.address = address;
            this.birthdate = birthdate;
            this.email = email;
            this.emailVerified = emailVerified;
            this.familyName = familyName;
            this.fullname = fullname;
            this.gender = gender;
            this.givenName = givenName;
            this.lastUpdateTime = lastUpdateTime;
            this.locale = locale;
            this.middleName = middleName;
            this.nickname = nickname;
            this.phoneNumber = phoneNumber;
            this.phoneNumberVerified = phoneNumberVerified;
            this.preferredUsername = preferredUsername;
            this.profilePage = profilePage;
            this.profilePicture = profilePicture;
            this.timezone = timezone;
            this.website = website;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.StandardAttribute getAddress() {
            return this.address;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.StandardAttribute getBirthdate() {
            return this.birthdate;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.StandardAttribute getEmail() {
            return this.email;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.StandardAttribute getEmailVerified() {
            return this.emailVerified;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.StandardAttribute getFamilyName() {
            return this.familyName;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.StandardAttribute getFullname() {
            return this.fullname;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.StandardAttribute getGender() {
            return this.gender;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.StandardAttribute getGivenName() {
            return this.givenName;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.StandardAttribute getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.StandardAttribute getLocale() {
            return this.locale;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.StandardAttribute getMiddleName() {
            return this.middleName;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.StandardAttribute getNickname() {
            return this.nickname;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.StandardAttribute getPhoneNumber() {
            return this.phoneNumber;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.StandardAttribute getPhoneNumberVerified() {
            return this.phoneNumberVerified;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.StandardAttribute getPreferredUsername() {
            return this.preferredUsername;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.StandardAttribute getProfilePage() {
            return this.profilePage;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.StandardAttribute getProfilePicture() {
            return this.profilePicture;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.StandardAttribute getTimezone() {
            return this.timezone;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.StandardAttribute getWebsite() {
            return this.website;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAddress() != null) {
                data.set("address", om.valueToTree(this.getAddress()));
            }
            if (this.getBirthdate() != null) {
                data.set("birthdate", om.valueToTree(this.getBirthdate()));
            }
            if (this.getEmail() != null) {
                data.set("email", om.valueToTree(this.getEmail()));
            }
            if (this.getEmailVerified() != null) {
                data.set("emailVerified", om.valueToTree(this.getEmailVerified()));
            }
            if (this.getFamilyName() != null) {
                data.set("familyName", om.valueToTree(this.getFamilyName()));
            }
            if (this.getFullname() != null) {
                data.set("fullname", om.valueToTree(this.getFullname()));
            }
            if (this.getGender() != null) {
                data.set("gender", om.valueToTree(this.getGender()));
            }
            if (this.getGivenName() != null) {
                data.set("givenName", om.valueToTree(this.getGivenName()));
            }
            if (this.getLastUpdateTime() != null) {
                data.set("lastUpdateTime", om.valueToTree(this.getLastUpdateTime()));
            }
            if (this.getLocale() != null) {
                data.set("locale", om.valueToTree(this.getLocale()));
            }
            if (this.getMiddleName() != null) {
                data.set("middleName", om.valueToTree(this.getMiddleName()));
            }
            if (this.getNickname() != null) {
                data.set("nickname", om.valueToTree(this.getNickname()));
            }
            if (this.getPhoneNumber() != null) {
                data.set("phoneNumber", om.valueToTree(this.getPhoneNumber()));
            }
            if (this.getPhoneNumberVerified() != null) {
                data.set("phoneNumberVerified", om.valueToTree(this.getPhoneNumberVerified()));
            }
            if (this.getPreferredUsername() != null) {
                data.set("preferredUsername", om.valueToTree(this.getPreferredUsername()));
            }
            if (this.getProfilePage() != null) {
                data.set("profilePage", om.valueToTree(this.getProfilePage()));
            }
            if (this.getProfilePicture() != null) {
                data.set("profilePicture", om.valueToTree(this.getProfilePicture()));
            }
            if (this.getTimezone() != null) {
                data.set("timezone", om.valueToTree(this.getTimezone()));
            }
            if (this.getWebsite() != null) {
                data.set("website", om.valueToTree(this.getWebsite()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-cognito.StandardAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            StandardAttributes.Jsii$Proxy that = (StandardAttributes.Jsii$Proxy) o;

            if (this.address != null ? !this.address.equals(that.address) : that.address != null) return false;
            if (this.birthdate != null ? !this.birthdate.equals(that.birthdate) : that.birthdate != null) return false;
            if (this.email != null ? !this.email.equals(that.email) : that.email != null) return false;
            if (this.emailVerified != null ? !this.emailVerified.equals(that.emailVerified) : that.emailVerified != null) return false;
            if (this.familyName != null ? !this.familyName.equals(that.familyName) : that.familyName != null) return false;
            if (this.fullname != null ? !this.fullname.equals(that.fullname) : that.fullname != null) return false;
            if (this.gender != null ? !this.gender.equals(that.gender) : that.gender != null) return false;
            if (this.givenName != null ? !this.givenName.equals(that.givenName) : that.givenName != null) return false;
            if (this.lastUpdateTime != null ? !this.lastUpdateTime.equals(that.lastUpdateTime) : that.lastUpdateTime != null) return false;
            if (this.locale != null ? !this.locale.equals(that.locale) : that.locale != null) return false;
            if (this.middleName != null ? !this.middleName.equals(that.middleName) : that.middleName != null) return false;
            if (this.nickname != null ? !this.nickname.equals(that.nickname) : that.nickname != null) return false;
            if (this.phoneNumber != null ? !this.phoneNumber.equals(that.phoneNumber) : that.phoneNumber != null) return false;
            if (this.phoneNumberVerified != null ? !this.phoneNumberVerified.equals(that.phoneNumberVerified) : that.phoneNumberVerified != null) return false;
            if (this.preferredUsername != null ? !this.preferredUsername.equals(that.preferredUsername) : that.preferredUsername != null) return false;
            if (this.profilePage != null ? !this.profilePage.equals(that.profilePage) : that.profilePage != null) return false;
            if (this.profilePicture != null ? !this.profilePicture.equals(that.profilePicture) : that.profilePicture != null) return false;
            if (this.timezone != null ? !this.timezone.equals(that.timezone) : that.timezone != null) return false;
            return this.website != null ? this.website.equals(that.website) : that.website == null;
        }

        @Override
        public final int hashCode() {
            int result = this.address != null ? this.address.hashCode() : 0;
            result = 31 * result + (this.birthdate != null ? this.birthdate.hashCode() : 0);
            result = 31 * result + (this.email != null ? this.email.hashCode() : 0);
            result = 31 * result + (this.emailVerified != null ? this.emailVerified.hashCode() : 0);
            result = 31 * result + (this.familyName != null ? this.familyName.hashCode() : 0);
            result = 31 * result + (this.fullname != null ? this.fullname.hashCode() : 0);
            result = 31 * result + (this.gender != null ? this.gender.hashCode() : 0);
            result = 31 * result + (this.givenName != null ? this.givenName.hashCode() : 0);
            result = 31 * result + (this.lastUpdateTime != null ? this.lastUpdateTime.hashCode() : 0);
            result = 31 * result + (this.locale != null ? this.locale.hashCode() : 0);
            result = 31 * result + (this.middleName != null ? this.middleName.hashCode() : 0);
            result = 31 * result + (this.nickname != null ? this.nickname.hashCode() : 0);
            result = 31 * result + (this.phoneNumber != null ? this.phoneNumber.hashCode() : 0);
            result = 31 * result + (this.phoneNumberVerified != null ? this.phoneNumberVerified.hashCode() : 0);
            result = 31 * result + (this.preferredUsername != null ? this.preferredUsername.hashCode() : 0);
            result = 31 * result + (this.profilePage != null ? this.profilePage.hashCode() : 0);
            result = 31 * result + (this.profilePicture != null ? this.profilePicture.hashCode() : 0);
            result = 31 * result + (this.timezone != null ? this.timezone.hashCode() : 0);
            result = 31 * result + (this.website != null ? this.website.hashCode() : 0);
            return result;
        }
    }
}
