package software.amazon.awscdk.services.cloudwatch.actions;

/**
 * Use an ApplicationAutoScaling StepScalingAction as an Alarm Action.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.applicationautoscaling.*;
 * import software.amazon.awscdk.services.cloudwatch.actions.*;
 * StepScalingAction stepScalingAction;
 * ApplicationScalingAction applicationScalingAction = new ApplicationScalingAction(stepScalingAction);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.63.2 (build a8a8833)", date = "2022-08-17T17:31:20.116Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cloudwatch.actions.$Module.class, fqn = "@aws-cdk/aws-cloudwatch-actions.ApplicationScalingAction")
public class ApplicationScalingAction extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.cloudwatch.IAlarmAction {

    protected ApplicationScalingAction(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ApplicationScalingAction(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param stepScalingAction This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ApplicationScalingAction(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.applicationautoscaling.StepScalingAction stepScalingAction) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(stepScalingAction, "stepScalingAction is required") });
    }

    /**
     * Returns an alarm action configuration to use an ApplicationScaling StepScalingAction as an alarm action.
     * <p>
     * @param _scope This parameter is required.
     * @param _alarm This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.AlarmActionConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct _scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.IAlarm _alarm) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.AlarmActionConfig.class), new Object[] { java.util.Objects.requireNonNull(_scope, "_scope is required"), java.util.Objects.requireNonNull(_alarm, "_alarm is required") });
    }
}
