package software.amazon.awscdk.services.certificatemanager;

/**
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.20.2 (build faba0be)", date = "2019-11-11T17:17:51.303Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.certificatemanager.$Module.class, fqn = "@aws-cdk/aws-certificatemanager.DnsValidatedCertificateProps")
@software.amazon.jsii.Jsii.Proxy(DnsValidatedCertificateProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface DnsValidatedCertificateProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.certificatemanager.CertificateProps {

    /**
     * Route 53 Hosted Zone used to perform DNS validation of the request.
     * 
     * The zone
     * must be authoritative for the domain name specified in the Certificate Request.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    software.amazon.awscdk.services.route53.IHostedZone getHostedZone();

    /**
     * Role to use for the custom resource that creates the validated certificate.
     * 
     * Default: - A new role will be created
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default software.amazon.awscdk.services.iam.IRole getCustomResourceRole() {
        return null;
    }

    /**
     * AWS region that will host the certificate.
     * 
     * This is needed especially
     * for certificates used for CloudFront distributions, which require the region
     * to be us-east-1.
     * 
     * Default: the region the stack is deployed in.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default java.lang.String getRegion() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DnsValidatedCertificateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DnsValidatedCertificateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder {
        private software.amazon.awscdk.services.route53.IHostedZone hostedZone;
        private software.amazon.awscdk.services.iam.IRole customResourceRole;
        private java.lang.String region;
        private java.lang.String domainName;
        private java.util.List<java.lang.String> subjectAlternativeNames;
        private java.util.Map<java.lang.String, java.lang.String> validationDomains;
        private software.amazon.awscdk.services.certificatemanager.ValidationMethod validationMethod;

        /**
         * Sets the value of HostedZone
         * @param hostedZone Route 53 Hosted Zone used to perform DNS validation of the request. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder hostedZone(software.amazon.awscdk.services.route53.IHostedZone hostedZone) {
            this.hostedZone = hostedZone;
            return this;
        }

        /**
         * Sets the value of CustomResourceRole
         * @param customResourceRole Role to use for the custom resource that creates the validated certificate.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder customResourceRole(software.amazon.awscdk.services.iam.IRole customResourceRole) {
            this.customResourceRole = customResourceRole;
            return this;
        }

        /**
         * Sets the value of Region
         * @param region AWS region that will host the certificate.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder region(java.lang.String region) {
            this.region = region;
            return this;
        }

        /**
         * Sets the value of DomainName
         * @param domainName Fully-qualified domain name to request a certificate for. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(java.lang.String domainName) {
            this.domainName = domainName;
            return this;
        }

        /**
         * Sets the value of SubjectAlternativeNames
         * @param subjectAlternativeNames Alternative domain names on your certificate.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subjectAlternativeNames(java.util.List<java.lang.String> subjectAlternativeNames) {
            this.subjectAlternativeNames = subjectAlternativeNames;
            return this;
        }

        /**
         * Sets the value of ValidationDomains
         * @param validationDomains What validation domain to use for every requested domain.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validationDomains(java.util.Map<java.lang.String, java.lang.String> validationDomains) {
            this.validationDomains = validationDomains;
            return this;
        }

        /**
         * Sets the value of ValidationMethod
         * @param validationMethod Validation method used to assert domain ownership.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validationMethod(software.amazon.awscdk.services.certificatemanager.ValidationMethod validationMethod) {
            this.validationMethod = validationMethod;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DnsValidatedCertificateProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public DnsValidatedCertificateProps build() {
            return new Jsii$Proxy(hostedZone, customResourceRole, region, domainName, subjectAlternativeNames, validationDomains, validationMethod);
        }
    }

    /**
     * An implementation for {@link DnsValidatedCertificateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DnsValidatedCertificateProps {
        private final software.amazon.awscdk.services.route53.IHostedZone hostedZone;
        private final software.amazon.awscdk.services.iam.IRole customResourceRole;
        private final java.lang.String region;
        private final java.lang.String domainName;
        private final java.util.List<java.lang.String> subjectAlternativeNames;
        private final java.util.Map<java.lang.String, java.lang.String> validationDomains;
        private final software.amazon.awscdk.services.certificatemanager.ValidationMethod validationMethod;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.hostedZone = this.jsiiGet("hostedZone", software.amazon.awscdk.services.route53.IHostedZone.class);
            this.customResourceRole = this.jsiiGet("customResourceRole", software.amazon.awscdk.services.iam.IRole.class);
            this.region = this.jsiiGet("region", java.lang.String.class);
            this.domainName = this.jsiiGet("domainName", java.lang.String.class);
            this.subjectAlternativeNames = this.jsiiGet("subjectAlternativeNames", java.util.List.class);
            this.validationDomains = this.jsiiGet("validationDomains", java.util.Map.class);
            this.validationMethod = this.jsiiGet("validationMethod", software.amazon.awscdk.services.certificatemanager.ValidationMethod.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.route53.IHostedZone hostedZone, final software.amazon.awscdk.services.iam.IRole customResourceRole, final java.lang.String region, final java.lang.String domainName, final java.util.List<java.lang.String> subjectAlternativeNames, final java.util.Map<java.lang.String, java.lang.String> validationDomains, final software.amazon.awscdk.services.certificatemanager.ValidationMethod validationMethod) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.hostedZone = java.util.Objects.requireNonNull(hostedZone, "hostedZone is required");
            this.customResourceRole = customResourceRole;
            this.region = region;
            this.domainName = java.util.Objects.requireNonNull(domainName, "domainName is required");
            this.subjectAlternativeNames = subjectAlternativeNames;
            this.validationDomains = validationDomains;
            this.validationMethod = validationMethod;
        }

        @Override
        public software.amazon.awscdk.services.route53.IHostedZone getHostedZone() {
            return this.hostedZone;
        }

        @Override
        public software.amazon.awscdk.services.iam.IRole getCustomResourceRole() {
            return this.customResourceRole;
        }

        @Override
        public java.lang.String getRegion() {
            return this.region;
        }

        @Override
        public java.lang.String getDomainName() {
            return this.domainName;
        }

        @Override
        public java.util.List<java.lang.String> getSubjectAlternativeNames() {
            return this.subjectAlternativeNames;
        }

        @Override
        public java.util.Map<java.lang.String, java.lang.String> getValidationDomains() {
            return this.validationDomains;
        }

        @Override
        public software.amazon.awscdk.services.certificatemanager.ValidationMethod getValidationMethod() {
            return this.validationMethod;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("hostedZone", om.valueToTree(this.getHostedZone()));
            if (this.getCustomResourceRole() != null) {
                data.set("customResourceRole", om.valueToTree(this.getCustomResourceRole()));
            }
            if (this.getRegion() != null) {
                data.set("region", om.valueToTree(this.getRegion()));
            }
            data.set("domainName", om.valueToTree(this.getDomainName()));
            if (this.getSubjectAlternativeNames() != null) {
                data.set("subjectAlternativeNames", om.valueToTree(this.getSubjectAlternativeNames()));
            }
            if (this.getValidationDomains() != null) {
                data.set("validationDomains", om.valueToTree(this.getValidationDomains()));
            }
            if (this.getValidationMethod() != null) {
                data.set("validationMethod", om.valueToTree(this.getValidationMethod()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-certificatemanager.DnsValidatedCertificateProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DnsValidatedCertificateProps.Jsii$Proxy that = (DnsValidatedCertificateProps.Jsii$Proxy) o;

            if (!hostedZone.equals(that.hostedZone)) return false;
            if (this.customResourceRole != null ? !this.customResourceRole.equals(that.customResourceRole) : that.customResourceRole != null) return false;
            if (this.region != null ? !this.region.equals(that.region) : that.region != null) return false;
            if (!domainName.equals(that.domainName)) return false;
            if (this.subjectAlternativeNames != null ? !this.subjectAlternativeNames.equals(that.subjectAlternativeNames) : that.subjectAlternativeNames != null) return false;
            if (this.validationDomains != null ? !this.validationDomains.equals(that.validationDomains) : that.validationDomains != null) return false;
            return this.validationMethod != null ? this.validationMethod.equals(that.validationMethod) : that.validationMethod == null;
        }

        @Override
        public int hashCode() {
            int result = this.hostedZone.hashCode();
            result = 31 * result + (this.customResourceRole != null ? this.customResourceRole.hashCode() : 0);
            result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
            result = 31 * result + (this.domainName.hashCode());
            result = 31 * result + (this.subjectAlternativeNames != null ? this.subjectAlternativeNames.hashCode() : 0);
            result = 31 * result + (this.validationDomains != null ? this.validationDomains.hashCode() : 0);
            result = 31 * result + (this.validationMethod != null ? this.validationMethod.hashCode() : 0);
            return result;
        }
    }
}
