package software.amazon.awscdk.services.certificatemanager;

/**
 * Properties for your certificate.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.10.3 (build 6bbf743)", date = "2019-04-24T21:06:26.046Z")
public interface CertificateProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * Fully-qualified domain name to request a certificate for.
     * 
     * May contain wildcards, such as ``*.domain.com``.
     */
    java.lang.String getDomainName();
    /**
     * Alternative domain names on your certificate.
     * 
     * Use this to register alternative domain names that represent the same site.
     */
    java.util.List<java.lang.String> getSubjectAlternativeNames();
    /**
     * What validation domain to use for every requested domain.
     * 
     * Has to be a superdomain of the requested domain.
     * 
     * Default: Apex domain is used for every domain that's not overridden.
     */
    java.util.Map<java.lang.String, java.lang.String> getValidationDomains();

    /**
     * @return a {@link Builder} of {@link CertificateProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link CertificateProps}
     */
    final class Builder {
        private java.lang.String _domainName;
        @javax.annotation.Nullable
        private java.util.List<java.lang.String> _subjectAlternativeNames;
        @javax.annotation.Nullable
        private java.util.Map<java.lang.String, java.lang.String> _validationDomains;

        /**
         * Sets the value of DomainName
         * @param value Fully-qualified domain name to request a certificate for.
         * @return {@code this}
         */
        public Builder withDomainName(final java.lang.String value) {
            this._domainName = java.util.Objects.requireNonNull(value, "domainName is required");
            return this;
        }
        /**
         * Sets the value of SubjectAlternativeNames
         * @param value Alternative domain names on your certificate.
         * @return {@code this}
         */
        public Builder withSubjectAlternativeNames(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this._subjectAlternativeNames = value;
            return this;
        }
        /**
         * Sets the value of ValidationDomains
         * @param value What validation domain to use for every requested domain.
         * @return {@code this}
         */
        public Builder withValidationDomains(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
            this._validationDomains = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CertificateProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public CertificateProps build() {
            return new CertificateProps() {
                private final java.lang.String $domainName = java.util.Objects.requireNonNull(_domainName, "domainName is required");
                @javax.annotation.Nullable
                private final java.util.List<java.lang.String> $subjectAlternativeNames = _subjectAlternativeNames;
                @javax.annotation.Nullable
                private final java.util.Map<java.lang.String, java.lang.String> $validationDomains = _validationDomains;

                @Override
                public java.lang.String getDomainName() {
                    return this.$domainName;
                }

                @Override
                public java.util.List<java.lang.String> getSubjectAlternativeNames() {
                    return this.$subjectAlternativeNames;
                }

                @Override
                public java.util.Map<java.lang.String, java.lang.String> getValidationDomains() {
                    return this.$validationDomains;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("domainName", om.valueToTree(this.getDomainName()));
                    obj.set("subjectAlternativeNames", om.valueToTree(this.getSubjectAlternativeNames()));
                    obj.set("validationDomains", om.valueToTree(this.getValidationDomains()));
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.certificatemanager.CertificateProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * Fully-qualified domain name to request a certificate for.
         * 
         * May contain wildcards, such as ``*.domain.com``.
         */
        @Override
        public java.lang.String getDomainName() {
            return this.jsiiGet("domainName", java.lang.String.class);
        }

        /**
         * Alternative domain names on your certificate.
         * 
         * Use this to register alternative domain names that represent the same site.
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<java.lang.String> getSubjectAlternativeNames() {
            return this.jsiiGet("subjectAlternativeNames", java.util.List.class);
        }

        /**
         * What validation domain to use for every requested domain.
         * 
         * Has to be a superdomain of the requested domain.
         * 
         * Default: Apex domain is used for every domain that's not overridden.
         */
        @Override
        @javax.annotation.Nullable
        public java.util.Map<java.lang.String, java.lang.String> getValidationDomains() {
            return this.jsiiGet("validationDomains", java.util.Map.class);
        }
    }
}
