package software.amazon.awscdk.services.certificatemanager;

/**
 * A certificate managed by AWS Certificate Manager.
 * 
 * IMPORTANT: if you are creating a certificate as part of your stack, the stack
 * will not complete creating until you read and follow the instructions in the
 * email that you will receive.
 * 
 * ACM will send validation emails to the following addresses:
 * 
 *   admin@domain.com
 *   administrator@domain.com
 *   hostmaster@domain.com
 *   postmaster@domain.com
 *   webmaster@domain.com
 * 
 * For every domain that you register.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.10.3 (build 6bbf743)", date = "2019-04-24T21:06:26.038Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.certificatemanager.$Module.class, fqn = "@aws-cdk/aws-certificatemanager.Certificate")
public class Certificate extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.certificatemanager.ICertificate {
    protected Certificate(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    public Certificate(final software.amazon.awscdk.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.certificatemanager.CertificateProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Import a certificate.
     */
    public static software.amazon.awscdk.services.certificatemanager.ICertificate import_(final software.amazon.awscdk.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.certificatemanager.CertificateImportProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.certificatemanager.Certificate.class, "import", software.amazon.awscdk.services.certificatemanager.ICertificate.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Export this certificate from the stack.
     */
    @Override
    public software.amazon.awscdk.services.certificatemanager.CertificateImportProps export() {
        return this.jsiiCall("export", software.amazon.awscdk.services.certificatemanager.CertificateImportProps.class);
    }

    /**
     * The certificate's ARN.
     */
    @Override
    public java.lang.String getCertificateArn() {
        return this.jsiiGet("certificateArn", java.lang.String.class);
    }
}
