package software.amazon.awscdk.services.certificatemanager;

/**
 * Properties for your certificate
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.7 (build b1c202b)", date = "2018-10-19T13:56:59.897Z")
public interface CertificateProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * Fully-qualified domain name to request a certificate for.
     * 
     * May contain wildcards, such as ``*.domain.com``.
     */
    java.lang.String getDomainName();
    /**
     * Fully-qualified domain name to request a certificate for.
     * 
     * May contain wildcards, such as ``*.domain.com``.
     */
    void setDomainName(final java.lang.String value);
    /**
     * Alternative domain names on your certificate.
     * 
     * Use this to register alternative domain names that represent the same site.
     */
    java.util.List<java.lang.String> getSubjectAlternativeNames();
    /**
     * Alternative domain names on your certificate.
     * 
     * Use this to register alternative domain names that represent the same site.
     */
    void setSubjectAlternativeNames(final java.util.List<java.lang.String> value);
    /**
     * What validation domain to use for every requested domain.
     * 
     * Has to be a superdomain of the requested domain.
     * @default Apex domain is used for every domain that's not overridden.
     */
    java.util.Map<java.lang.String, java.lang.String> getValidationDomains();
    /**
     * What validation domain to use for every requested domain.
     * 
     * Has to be a superdomain of the requested domain.
     * @default Apex domain is used for every domain that's not overridden.
     */
    void setValidationDomains(final java.util.Map<java.lang.String, java.lang.String> value);

    /**
     * @return a {@link Builder} of {@link CertificateProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link CertificateProps}
     */
    final class Builder {
        private java.lang.String _domainName;
        @javax.annotation.Nullable
        private java.util.List<java.lang.String> _subjectAlternativeNames;
        @javax.annotation.Nullable
        private java.util.Map<java.lang.String, java.lang.String> _validationDomains;

        /**
         * Sets the value of DomainName
         * @param value Fully-qualified domain name to request a certificate for.

May contain wildcards, such as ``*.domain.com``.
         * @return {@code this}
         */
        public Builder withDomainName(final java.lang.String value) {
            this._domainName = java.util.Objects.requireNonNull(value, "domainName is required");
            return this;
        }
        /**
         * Sets the value of SubjectAlternativeNames
         * @param value Alternative domain names on your certificate.

Use this to register alternative domain names that represent the same site.
         * @return {@code this}
         */
        public Builder withSubjectAlternativeNames(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this._subjectAlternativeNames = value;
            return this;
        }
        /**
         * Sets the value of ValidationDomains
         * @param value What validation domain to use for every requested domain.

Has to be a superdomain of the requested domain.
         * @return {@code this}
         */
        public Builder withValidationDomains(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
            this._validationDomains = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CertificateProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public CertificateProps build() {
            return new CertificateProps() {
                private java.lang.String $domainName = java.util.Objects.requireNonNull(_domainName, "domainName is required");
                @javax.annotation.Nullable
                private java.util.List<java.lang.String> $subjectAlternativeNames = _subjectAlternativeNames;
                @javax.annotation.Nullable
                private java.util.Map<java.lang.String, java.lang.String> $validationDomains = _validationDomains;

                @Override
                public java.lang.String getDomainName() {
                    return this.$domainName;
                }

                @Override
                public void setDomainName(final java.lang.String value) {
                    this.$domainName = java.util.Objects.requireNonNull(value, "domainName is required");
                }

                @Override
                public java.util.List<java.lang.String> getSubjectAlternativeNames() {
                    return this.$subjectAlternativeNames;
                }

                @Override
                public void setSubjectAlternativeNames(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
                    this.$subjectAlternativeNames = value;
                }

                @Override
                public java.util.Map<java.lang.String, java.lang.String> getValidationDomains() {
                    return this.$validationDomains;
                }

                @Override
                public void setValidationDomains(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
                    this.$validationDomains = value;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.certificatemanager.CertificateProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * Fully-qualified domain name to request a certificate for.
         * 
         * May contain wildcards, such as ``*.domain.com``.
         */
        @Override
        public java.lang.String getDomainName() {
            return this.jsiiGet("domainName", java.lang.String.class);
        }

        /**
         * Fully-qualified domain name to request a certificate for.
         * 
         * May contain wildcards, such as ``*.domain.com``.
         */
        @Override
        public void setDomainName(final java.lang.String value) {
            this.jsiiSet("domainName", java.util.Objects.requireNonNull(value, "domainName is required"));
        }

        /**
         * Alternative domain names on your certificate.
         * 
         * Use this to register alternative domain names that represent the same site.
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<java.lang.String> getSubjectAlternativeNames() {
            return this.jsiiGet("subjectAlternativeNames", java.util.List.class);
        }

        /**
         * Alternative domain names on your certificate.
         * 
         * Use this to register alternative domain names that represent the same site.
         */
        @Override
        public void setSubjectAlternativeNames(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this.jsiiSet("subjectAlternativeNames", value);
        }

        /**
         * What validation domain to use for every requested domain.
         * 
         * Has to be a superdomain of the requested domain.
         * @default Apex domain is used for every domain that's not overridden.
         */
        @Override
        @javax.annotation.Nullable
        public java.util.Map<java.lang.String, java.lang.String> getValidationDomains() {
            return this.jsiiGet("validationDomains", java.util.Map.class);
        }

        /**
         * What validation domain to use for every requested domain.
         * 
         * Has to be a superdomain of the requested domain.
         * @default Apex domain is used for every domain that's not overridden.
         */
        @Override
        public void setValidationDomains(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
            this.jsiiSet("validationDomains", value);
        }
    }
}
