package software.amazon.awscdk.services.appmesh;

/**
 * (experimental) Route represents a new or existing route attached to a VirtualRouter and Mesh.
 * <p>
 * @see https://docs.aws.amazon.com/app-mesh/latest/userguide/routes.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.24.0 (build b722f66)", date = "2021-03-11T13:47:05.092Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.appmesh.$Module.class, fqn = "@aws-cdk/aws-appmesh.Route")
public class Route extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.appmesh.IRoute {

    protected Route(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Route(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public Route(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.RouteProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Import an existing Route given an ARN.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param routeArn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.IRoute fromRouteArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String routeArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.Route.class, "fromRouteArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.IRoute.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(routeArn, "routeArn is required") });
    }

    /**
     * (experimental) Import an existing Route given attributes.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.IRoute fromRouteAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.RouteAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.Route.class, "fromRouteAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.IRoute.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * (experimental) The Amazon Resource Name (ARN) for the route.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getRouteArn() {
        return software.amazon.jsii.Kernel.get(this, "routeArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The name of the Route.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getRouteName() {
        return software.amazon.jsii.Kernel.get(this, "routeName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The VirtualRouter the Route belongs to.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.IVirtualRouter getVirtualRouter() {
        return software.amazon.jsii.Kernel.get(this, "virtualRouter", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.IVirtualRouter.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.appmesh.Route}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.appmesh.Route> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.appmesh.RouteProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.appmesh.RouteProps.Builder();
        }

        /**
         * (experimental) Protocol specific spec.
         * <p>
         * @return {@code this}
         * @param routeSpec Protocol specific spec. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder routeSpec(final software.amazon.awscdk.services.appmesh.RouteSpec routeSpec) {
            this.props.routeSpec(routeSpec);
            return this;
        }

        /**
         * (experimental) The name of the route.
         * <p>
         * Default: - An automatically generated name
         * <p>
         * @return {@code this}
         * @param routeName The name of the route. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder routeName(final java.lang.String routeName) {
            this.props.routeName(routeName);
            return this;
        }

        /**
         * (experimental) The service mesh to define the route in.
         * <p>
         * @return {@code this}
         * @param mesh The service mesh to define the route in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder mesh(final software.amazon.awscdk.services.appmesh.IMesh mesh) {
            this.props.mesh(mesh);
            return this;
        }

        /**
         * (experimental) The VirtualRouter the Route belongs to.
         * <p>
         * @return {@code this}
         * @param virtualRouter The VirtualRouter the Route belongs to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder virtualRouter(final software.amazon.awscdk.services.appmesh.IVirtualRouter virtualRouter) {
            this.props.virtualRouter(virtualRouter);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.appmesh.Route}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.appmesh.Route build() {
            return new software.amazon.awscdk.services.appmesh.Route(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
