package software.amazon.awscdk.services.appmesh;

/**
 * (experimental) Properties used to define healthchecks when creating virtual nodes.
 * <p>
 * All values have a default if only specified as {} when creating.
 * If property not set, then no healthchecks will be defined.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.24.0 (build b722f66)", date = "2021-03-11T13:47:05.086Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.appmesh.$Module.class, fqn = "@aws-cdk/aws-appmesh.HealthCheck")
@software.amazon.jsii.Jsii.Proxy(HealthCheck.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface HealthCheck extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) Number of successful attempts before considering the node UP.
     * <p>
     * Default: 2
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getHealthyThreshold() {
        return null;
    }

    /**
     * (experimental) Interval in milliseconds to re-check.
     * <p>
     * Default: 5 seconds
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getInterval() {
        return null;
    }

    /**
     * (experimental) The path where the application expects any health-checks, this can also be the application path.
     * <p>
     * Default: /
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getPath() {
        return null;
    }

    /**
     * (experimental) The TCP port number for the healthcheck.
     * <p>
     * Default: - same as corresponding port mapping
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
        return null;
    }

    /**
     * (experimental) The protocol to use for the healthcheck, for convinience a const enum has been defined.
     * <p>
     * Protocol.HTTP or Protocol.TCP
     * <p>
     * Default: - same as corresponding port mapping
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appmesh.Protocol getProtocol() {
        return null;
    }

    /**
     * (experimental) Timeout in milli-seconds for the healthcheck to be considered a fail.
     * <p>
     * Default: 2 seconds
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getTimeout() {
        return null;
    }

    /**
     * (experimental) Number of failed attempts before considering the node DOWN.
     * <p>
     * Default: 2
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getUnhealthyThreshold() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link HealthCheck}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link HealthCheck}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<HealthCheck> {
        private java.lang.Number healthyThreshold;
        private software.amazon.awscdk.core.Duration interval;
        private java.lang.String path;
        private java.lang.Number port;
        private software.amazon.awscdk.services.appmesh.Protocol protocol;
        private software.amazon.awscdk.core.Duration timeout;
        private java.lang.Number unhealthyThreshold;

        /**
         * Sets the value of {@link HealthCheck#getHealthyThreshold}
         * @param healthyThreshold Number of successful attempts before considering the node UP.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder healthyThreshold(java.lang.Number healthyThreshold) {
            this.healthyThreshold = healthyThreshold;
            return this;
        }

        /**
         * Sets the value of {@link HealthCheck#getInterval}
         * @param interval Interval in milliseconds to re-check.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder interval(software.amazon.awscdk.core.Duration interval) {
            this.interval = interval;
            return this;
        }

        /**
         * Sets the value of {@link HealthCheck#getPath}
         * @param path The path where the application expects any health-checks, this can also be the application path.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder path(java.lang.String path) {
            this.path = path;
            return this;
        }

        /**
         * Sets the value of {@link HealthCheck#getPort}
         * @param port The TCP port number for the healthcheck.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder port(java.lang.Number port) {
            this.port = port;
            return this;
        }

        /**
         * Sets the value of {@link HealthCheck#getProtocol}
         * @param protocol The protocol to use for the healthcheck, for convinience a const enum has been defined.
         *                 Protocol.HTTP or Protocol.TCP
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder protocol(software.amazon.awscdk.services.appmesh.Protocol protocol) {
            this.protocol = protocol;
            return this;
        }

        /**
         * Sets the value of {@link HealthCheck#getTimeout}
         * @param timeout Timeout in milli-seconds for the healthcheck to be considered a fail.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder timeout(software.amazon.awscdk.core.Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Sets the value of {@link HealthCheck#getUnhealthyThreshold}
         * @param unhealthyThreshold Number of failed attempts before considering the node DOWN.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder unhealthyThreshold(java.lang.Number unhealthyThreshold) {
            this.unhealthyThreshold = unhealthyThreshold;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link HealthCheck}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public HealthCheck build() {
            return new Jsii$Proxy(healthyThreshold, interval, path, port, protocol, timeout, unhealthyThreshold);
        }
    }

    /**
     * An implementation for {@link HealthCheck}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HealthCheck {
        private final java.lang.Number healthyThreshold;
        private final software.amazon.awscdk.core.Duration interval;
        private final java.lang.String path;
        private final java.lang.Number port;
        private final software.amazon.awscdk.services.appmesh.Protocol protocol;
        private final software.amazon.awscdk.core.Duration timeout;
        private final java.lang.Number unhealthyThreshold;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.healthyThreshold = software.amazon.jsii.Kernel.get(this, "healthyThreshold", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.interval = software.amazon.jsii.Kernel.get(this, "interval", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
            this.path = software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.protocol = software.amazon.jsii.Kernel.get(this, "protocol", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.Protocol.class));
            this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
            this.unhealthyThreshold = software.amazon.jsii.Kernel.get(this, "unhealthyThreshold", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final java.lang.Number healthyThreshold, final software.amazon.awscdk.core.Duration interval, final java.lang.String path, final java.lang.Number port, final software.amazon.awscdk.services.appmesh.Protocol protocol, final software.amazon.awscdk.core.Duration timeout, final java.lang.Number unhealthyThreshold) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.healthyThreshold = healthyThreshold;
            this.interval = interval;
            this.path = path;
            this.port = port;
            this.protocol = protocol;
            this.timeout = timeout;
            this.unhealthyThreshold = unhealthyThreshold;
        }

        @Override
        public final java.lang.Number getHealthyThreshold() {
            return this.healthyThreshold;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getInterval() {
            return this.interval;
        }

        @Override
        public final java.lang.String getPath() {
            return this.path;
        }

        @Override
        public final java.lang.Number getPort() {
            return this.port;
        }

        @Override
        public final software.amazon.awscdk.services.appmesh.Protocol getProtocol() {
            return this.protocol;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getTimeout() {
            return this.timeout;
        }

        @Override
        public final java.lang.Number getUnhealthyThreshold() {
            return this.unhealthyThreshold;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getHealthyThreshold() != null) {
                data.set("healthyThreshold", om.valueToTree(this.getHealthyThreshold()));
            }
            if (this.getInterval() != null) {
                data.set("interval", om.valueToTree(this.getInterval()));
            }
            if (this.getPath() != null) {
                data.set("path", om.valueToTree(this.getPath()));
            }
            if (this.getPort() != null) {
                data.set("port", om.valueToTree(this.getPort()));
            }
            if (this.getProtocol() != null) {
                data.set("protocol", om.valueToTree(this.getProtocol()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }
            if (this.getUnhealthyThreshold() != null) {
                data.set("unhealthyThreshold", om.valueToTree(this.getUnhealthyThreshold()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-appmesh.HealthCheck"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            HealthCheck.Jsii$Proxy that = (HealthCheck.Jsii$Proxy) o;

            if (this.healthyThreshold != null ? !this.healthyThreshold.equals(that.healthyThreshold) : that.healthyThreshold != null) return false;
            if (this.interval != null ? !this.interval.equals(that.interval) : that.interval != null) return false;
            if (this.path != null ? !this.path.equals(that.path) : that.path != null) return false;
            if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
            if (this.protocol != null ? !this.protocol.equals(that.protocol) : that.protocol != null) return false;
            if (this.timeout != null ? !this.timeout.equals(that.timeout) : that.timeout != null) return false;
            return this.unhealthyThreshold != null ? this.unhealthyThreshold.equals(that.unhealthyThreshold) : that.unhealthyThreshold == null;
        }

        @Override
        public final int hashCode() {
            int result = this.healthyThreshold != null ? this.healthyThreshold.hashCode() : 0;
            result = 31 * result + (this.interval != null ? this.interval.hashCode() : 0);
            result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
            result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
            result = 31 * result + (this.protocol != null ? this.protocol.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            result = 31 * result + (this.unhealthyThreshold != null ? this.unhealthyThreshold.hashCode() : 0);
            return result;
        }
    }
}
