package software.amazon.awscdk.services.appmesh;

/**
 * (experimental) Represents the properties needed to define CloudMap Service Discovery.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.24.0 (build b722f66)", date = "2021-03-11T13:47:05.083Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.appmesh.$Module.class, fqn = "@aws-cdk/aws-appmesh.CloudMapServiceDiscoveryOptions")
@software.amazon.jsii.Jsii.Proxy(CloudMapServiceDiscoveryOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface CloudMapServiceDiscoveryOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The AWS Cloud Map Service to use for service discovery.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicediscovery.IService getService();

    /**
     * (experimental) A string map that contains attributes with values that you can use to filter instances by any custom attribute that you specified when you registered the instance.
     * <p>
     * Only instances that match all of the specified
     * key/value pairs will be returned.
     * <p>
     * Default: - no instance attributes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getInstanceAttributes() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CloudMapServiceDiscoveryOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CloudMapServiceDiscoveryOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<CloudMapServiceDiscoveryOptions> {
        private software.amazon.awscdk.services.servicediscovery.IService service;
        private java.util.Map<java.lang.String, java.lang.String> instanceAttributes;

        /**
         * Sets the value of {@link CloudMapServiceDiscoveryOptions#getService}
         * @param service The AWS Cloud Map Service to use for service discovery. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder service(software.amazon.awscdk.services.servicediscovery.IService service) {
            this.service = service;
            return this;
        }

        /**
         * Sets the value of {@link CloudMapServiceDiscoveryOptions#getInstanceAttributes}
         * @param instanceAttributes A string map that contains attributes with values that you can use to filter instances by any custom attribute that you specified when you registered the instance.
         *                           Only instances that match all of the specified
         *                           key/value pairs will be returned.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder instanceAttributes(java.util.Map<java.lang.String, java.lang.String> instanceAttributes) {
            this.instanceAttributes = instanceAttributes;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CloudMapServiceDiscoveryOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public CloudMapServiceDiscoveryOptions build() {
            return new Jsii$Proxy(service, instanceAttributes);
        }
    }

    /**
     * An implementation for {@link CloudMapServiceDiscoveryOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CloudMapServiceDiscoveryOptions {
        private final software.amazon.awscdk.services.servicediscovery.IService service;
        private final java.util.Map<java.lang.String, java.lang.String> instanceAttributes;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.service = software.amazon.jsii.Kernel.get(this, "service", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.servicediscovery.IService.class));
            this.instanceAttributes = software.amazon.jsii.Kernel.get(this, "instanceAttributes", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final software.amazon.awscdk.services.servicediscovery.IService service, final java.util.Map<java.lang.String, java.lang.String> instanceAttributes) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.service = java.util.Objects.requireNonNull(service, "service is required");
            this.instanceAttributes = instanceAttributes;
        }

        @Override
        public final software.amazon.awscdk.services.servicediscovery.IService getService() {
            return this.service;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getInstanceAttributes() {
            return this.instanceAttributes;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("service", om.valueToTree(this.getService()));
            if (this.getInstanceAttributes() != null) {
                data.set("instanceAttributes", om.valueToTree(this.getInstanceAttributes()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-appmesh.CloudMapServiceDiscoveryOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CloudMapServiceDiscoveryOptions.Jsii$Proxy that = (CloudMapServiceDiscoveryOptions.Jsii$Proxy) o;

            if (!service.equals(that.service)) return false;
            return this.instanceAttributes != null ? this.instanceAttributes.equals(that.instanceAttributes) : that.instanceAttributes == null;
        }

        @Override
        public final int hashCode() {
            int result = this.service.hashCode();
            result = 31 * result + (this.instanceAttributes != null ? this.instanceAttributes.hashCode() : 0);
            return result;
        }
    }
}
