/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.typeresolution.rules;

import java.util.List;
import net.sourceforge.pmd.AbstractJavaRule;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.ast.ASTExtendsList;
import net.sourceforge.pmd.ast.ASTImplementsList;
import net.sourceforge.pmd.ast.ASTImportDeclaration;
import net.sourceforge.pmd.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.ast.ASTName;
import net.sourceforge.pmd.ast.Node;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.properties.BooleanProperty;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignatureDeclareThrowsException
extends AbstractJavaRule {
    private static final PropertyDescriptor ignoreJUnitCompletelyDescriptor = new BooleanProperty("IgnoreJUnitCompletely", "If true, all methods in a JUnit testcase may throw Exception", false, 1.0f);
    private boolean junitImported = false;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTName;
    private static final /* synthetic */ Class class$java$lang$Object;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTExtendsList;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTImplementsList;

    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        ASTImplementsList impl;
        if (this.junitImported) {
            return super.visit(node, data);
        }
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTImplementsList;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTImplementsList = new ASTImplementsList[0].getClass().getComponentType();
        }
        if ((impl = (ASTImplementsList)node.getFirstChildOfType(clazz)) != null && impl.jjtGetParent().equals(node)) {
            for (int ix = 0; ix < impl.jjtGetNumChildren(); ++ix) {
                ASTClassOrInterfaceType type = (ASTClassOrInterfaceType)impl.jjtGetChild(ix);
                if (!this.isJUnitTest(type)) continue;
                this.junitImported = true;
                return super.visit(node, data);
            }
        }
        if (node.jjtGetNumChildren() != 0) {
            ASTClassOrInterfaceType type;
            Class<?> clazz2 = node.jjtGetChild(0).getClass();
            Class<?> clazz3 = class$net$sourceforge$pmd$ast$ASTExtendsList;
            if (clazz3 == null) {
                clazz3 = class$net$sourceforge$pmd$ast$ASTExtendsList = new ASTExtendsList[0].getClass().getComponentType();
            }
            if (clazz2.equals(clazz3) && this.isJUnitTest(type = (ASTClassOrInterfaceType)((SimpleNode)node.jjtGetChild(0)).jjtGetChild(0))) {
                this.junitImported = true;
                return super.visit(node, data);
            }
        }
        return super.visit(node, data);
    }

    private boolean isJUnitTest(ASTClassOrInterfaceType type) {
        Class clazz = type.getType();
        if (clazz == null) {
            if ("junit.framework.Test".equals(type.getImage())) {
                return true;
            }
        } else {
            if (this.isJUnitTest(clazz)) {
                return true;
            }
            while (clazz != null) {
                Class<?> clazz2 = class$java$lang$Object;
                if (clazz2 == null) {
                    clazz2 = new Object[0].getClass().getComponentType();
                }
                if (clazz2.equals(clazz)) break;
                for (Class<?> intf : clazz.getInterfaces()) {
                    if (!this.isJUnitTest(intf)) continue;
                    return true;
                }
                clazz = clazz.getSuperclass();
            }
        }
        return false;
    }

    private boolean isJUnitTest(Class<?> clazz) {
        return clazz.getName().equals("junit.framework.Test");
    }

    @Override
    public Object visit(ASTImportDeclaration node, Object o) {
        if (node.getImportedName().indexOf("junit") != -1) {
            this.junitImported = true;
        }
        return super.visit(node, o);
    }

    @Override
    public Object visit(ASTMethodDeclaration methodDeclaration, Object o) {
        if (this.junitImported && this.isAllowedMethod(methodDeclaration)) {
            return super.visit(methodDeclaration, o);
        }
        this.checkExceptions(methodDeclaration, o);
        return super.visit(methodDeclaration, o);
    }

    private boolean isAllowedMethod(ASTMethodDeclaration methodDeclaration) {
        if (this.getBooleanProperty(ignoreJUnitCompletelyDescriptor)) {
            return true;
        }
        return methodDeclaration.getMethodName().equals("setUp") || methodDeclaration.getMethodName().equals("tearDown");
    }

    @Override
    public Object visit(ASTConstructorDeclaration constructorDeclaration, Object o) {
        this.checkExceptions(constructorDeclaration, o);
        return super.visit(constructorDeclaration, o);
    }

    private void checkExceptions(SimpleNode method, Object o) {
        List<ASTName> exceptionList;
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTName;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTName = new ASTName[0].getClass().getComponentType();
        }
        if (!(exceptionList = method.findChildrenOfType(clazz)).isEmpty()) {
            this.evaluateExceptions(exceptionList, o);
        }
    }

    private void evaluateExceptions(List<ASTName> exceptionList, Object context) {
        for (ASTName exception : exceptionList) {
            if (!this.hasDeclaredExceptionInSignature(exception)) continue;
            this.addViolation(context, exception);
        }
    }

    private boolean hasDeclaredExceptionInSignature(ASTName exception) {
        return exception.hasImageEqualTo("Exception") && this.isParentSignatureDeclaration(exception);
    }

    private boolean isParentSignatureDeclaration(ASTName exception) {
        Node parent = exception.jjtGetParent().jjtGetParent();
        return parent instanceof ASTMethodDeclaration || parent instanceof ASTConstructorDeclaration;
    }
}

