/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules.basic;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.ast.ASTAssignmentOperator;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.ast.ASTConditionalAndExpression;
import net.sourceforge.pmd.ast.ASTConditionalOrExpression;
import net.sourceforge.pmd.ast.ASTEqualityExpression;
import net.sourceforge.pmd.ast.ASTExpression;
import net.sourceforge.pmd.ast.ASTIfStatement;
import net.sourceforge.pmd.ast.ASTLiteral;
import net.sourceforge.pmd.ast.ASTName;
import net.sourceforge.pmd.ast.ASTNullLiteral;
import net.sourceforge.pmd.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.ast.Node;
import net.sourceforge.pmd.ast.SimpleJavaNode;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrokenNullCheck
extends AbstractRule {
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTClassOrInterfaceType;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTName;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTLiteral;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTPrimaryPrefix;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTConditionalOrExpression;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTPrimarySuffix;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTNullLiteral;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTAssignmentOperator;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTEqualityExpression;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTPrimaryExpression;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTConditionalAndExpression;

    @Override
    public Object visit(ASTIfStatement node, Object data) {
        ASTConditionalOrExpression conditionalOrExpression;
        Class<?> clazz;
        ASTConditionalAndExpression conditionalAndExpression;
        ASTExpression expression = (ASTExpression)node.jjtGetChild(0);
        Class<?> clazz2 = class$net$sourceforge$pmd$ast$ASTConditionalAndExpression;
        if (clazz2 == null) {
            clazz2 = class$net$sourceforge$pmd$ast$ASTConditionalAndExpression = new ASTConditionalAndExpression[0].getClass().getComponentType();
        }
        if ((conditionalAndExpression = (ASTConditionalAndExpression)expression.getFirstChildOfType(clazz2)) != null) {
            this.checkForViolations(node, data, conditionalAndExpression);
        }
        if ((clazz = class$net$sourceforge$pmd$ast$ASTConditionalOrExpression) == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTConditionalOrExpression = new ASTConditionalOrExpression[0].getClass().getComponentType();
        }
        if ((conditionalOrExpression = (ASTConditionalOrExpression)expression.getFirstChildOfType(clazz)) != null) {
            this.checkForViolations(node, data, conditionalOrExpression);
        }
        return super.visit(node, data);
    }

    private void checkForViolations(ASTIfStatement node, Object data, SimpleJavaNode conditionalExpression) {
        ASTNullLiteral nullLiteral;
        ASTEqualityExpression equalityExpression;
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTEqualityExpression;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTEqualityExpression = new ASTEqualityExpression[0].getClass().getComponentType();
        }
        if ((equalityExpression = (ASTEqualityExpression)this.getFirstDirectChildOfType(clazz, conditionalExpression)) == null) {
            return;
        }
        if (conditionalExpression instanceof ASTConditionalAndExpression && !"==".equals(equalityExpression.getImage())) {
            return;
        }
        if (conditionalExpression instanceof ASTConditionalOrExpression && !"!=".equals(equalityExpression.getImage())) {
            return;
        }
        Class<?> clazz2 = class$net$sourceforge$pmd$ast$ASTNullLiteral;
        if (clazz2 == null) {
            clazz2 = class$net$sourceforge$pmd$ast$ASTNullLiteral = new ASTNullLiteral[0].getClass().getComponentType();
        }
        if ((nullLiteral = (ASTNullLiteral)equalityExpression.getFirstChildOfType(clazz2)) == null) {
            return;
        }
        Class<?> clazz3 = class$net$sourceforge$pmd$ast$ASTAssignmentOperator;
        if (clazz3 == null) {
            clazz3 = class$net$sourceforge$pmd$ast$ASTAssignmentOperator = new ASTAssignmentOperator[0].getClass().getComponentType();
        }
        if (conditionalExpression.getFirstChildOfType(clazz3) != null) {
            return;
        }
        ASTPrimaryExpression nullCompareExpression = this.findNullCompareExpression(equalityExpression);
        if (nullCompareExpression == null) {
            return;
        }
        for (int i = 0; i < conditionalExpression.jjtGetNumChildren(); ++i) {
            ASTPrimaryExpression conditionalPrimaryExpression;
            ASTEqualityExpression nullEqualityExpression;
            SimpleJavaNode conditionalSubnode = (SimpleJavaNode)conditionalExpression.jjtGetChild(i);
            Class<?> clazz4 = class$net$sourceforge$pmd$ast$ASTEqualityExpression;
            if (clazz4 == null) {
                clazz4 = new ASTEqualityExpression[0].getClass().getComponentType();
            }
            if (conditionalSubnode.equals(nullEqualityExpression = (ASTEqualityExpression)nullLiteral.getFirstParentOfType(clazz4))) continue;
            if (conditionalSubnode instanceof ASTPrimaryExpression) {
                conditionalPrimaryExpression = (ASTPrimaryExpression)conditionalSubnode;
            } else {
                Class<?> clazz5 = class$net$sourceforge$pmd$ast$ASTPrimaryExpression;
                if (clazz5 == null) {
                    clazz5 = new ASTPrimaryExpression[0].getClass().getComponentType();
                }
                conditionalPrimaryExpression = (ASTPrimaryExpression)conditionalSubnode.getFirstChildOfType(clazz5);
            }
            if (!this.primaryExpressionsAreEqual(nullCompareExpression, conditionalPrimaryExpression)) continue;
            this.addViolation(data, node);
        }
    }

    private boolean primaryExpressionsAreEqual(ASTPrimaryExpression nullCompareVariable, ASTPrimaryExpression expressionUsage) {
        ArrayList<String> nullCompareNames = new ArrayList<String>();
        this.findExpressionNames(nullCompareVariable, nullCompareNames);
        ArrayList<String> expressionUsageNames = new ArrayList<String>();
        this.findExpressionNames(expressionUsage, expressionUsageNames);
        for (int i = 0; i < nullCompareNames.size(); ++i) {
            String expressionUsageName;
            if (expressionUsageNames.size() == i) {
                return false;
            }
            String nullCompareExpressionName = (String)nullCompareNames.get(i);
            if (nullCompareExpressionName.equals(expressionUsageName = (String)expressionUsageNames.get(i)) || expressionUsageName.startsWith(new StringBuffer().append(nullCompareExpressionName).append(".").toString())) continue;
            return false;
        }
        return true;
    }

    private void findExpressionNames(Node nullCompareVariable, List<String> results) {
        for (int i = 0; i < nullCompareVariable.jjtGetNumChildren(); ++i) {
            Node child = nullCompareVariable.jjtGetChild(i);
            Class<?> clazz = child.getClass();
            Class<?> clazz2 = class$net$sourceforge$pmd$ast$ASTName;
            if (clazz2 == null) {
                clazz2 = new ASTName[0].getClass().getComponentType();
            }
            if (clazz.equals(clazz2)) {
                results.add(((ASTName)child).getImage());
            } else {
                Class<?> clazz3 = child.getClass();
                Class<?> clazz4 = class$net$sourceforge$pmd$ast$ASTLiteral;
                if (clazz4 == null) {
                    clazz4 = new ASTLiteral[0].getClass().getComponentType();
                }
                if (clazz3.equals(clazz4)) {
                    String literalImage = ((ASTLiteral)child).getImage();
                    if (literalImage != null) {
                        results.add(literalImage);
                    }
                } else {
                    String name;
                    Class<?> clazz5 = child.getClass();
                    Class<?> clazz6 = class$net$sourceforge$pmd$ast$ASTPrimarySuffix;
                    if (clazz6 == null) {
                        clazz6 = new ASTPrimarySuffix[0].getClass().getComponentType();
                    }
                    if (clazz5.equals(clazz6)) {
                        name = ((ASTPrimarySuffix)child).getImage();
                        if (name != null && !name.equals("")) {
                            results.add(name);
                        }
                    } else {
                        Class<?> clazz7 = child.getClass();
                        Class<?> clazz8 = class$net$sourceforge$pmd$ast$ASTClassOrInterfaceType;
                        if (clazz8 == null) {
                            clazz8 = new ASTClassOrInterfaceType[0].getClass().getComponentType();
                        }
                        if (clazz7.equals(clazz8)) {
                            name = ((ASTClassOrInterfaceType)child).getImage();
                            results.add(name);
                        }
                    }
                }
            }
            if (child.jjtGetNumChildren() <= 0) continue;
            this.findExpressionNames(child, results);
        }
    }

    private ASTPrimaryExpression findNullCompareExpression(ASTEqualityExpression equalityExpression) {
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTPrimaryExpression;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTPrimaryExpression = new ASTPrimaryExpression[0].getClass().getComponentType();
        }
        List primaryExpressions = equalityExpression.findChildrenOfType(clazz);
        for (ASTPrimaryExpression primaryExpression : primaryExpressions) {
            Class<?> clazz2 = class$net$sourceforge$pmd$ast$ASTPrimaryPrefix;
            if (clazz2 == null) {
                clazz2 = new ASTPrimaryPrefix[0].getClass().getComponentType();
            }
            List primaryPrefixes = primaryExpression.findChildrenOfType(clazz2);
            for (ASTPrimaryPrefix primaryPrefix : primaryPrefixes) {
                ASTName name;
                Class<?> clazz3 = class$net$sourceforge$pmd$ast$ASTName;
                if (clazz3 == null) {
                    clazz3 = new ASTName[0].getClass().getComponentType();
                }
                if ((name = (ASTName)primaryPrefix.getFirstChildOfType(clazz3)) == null) continue;
                return primaryExpression;
            }
        }
        return null;
    }

    private <T> T getFirstDirectChildOfType(Class<T> childType, Node node) {
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            SimpleJavaNode simpleNode = (SimpleJavaNode)node.jjtGetChild(i);
            if (!simpleNode.getClass().equals(childType)) continue;
            return (T)simpleNode;
        }
        return null;
    }
}

