/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules.design;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.AbstractJavaRule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.ast.ASTArgumentList;
import net.sourceforge.pmd.ast.ASTCastExpression;
import net.sourceforge.pmd.ast.ASTCatchStatement;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.ast.ASTName;
import net.sourceforge.pmd.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.ast.ASTThrowStatement;
import net.sourceforge.pmd.ast.Node;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.symboltable.NameOccurrence;
import net.sourceforge.pmd.symboltable.VariableNameDeclaration;
import org.jaxen.JaxenException;

public class PreserveStackTrace
extends AbstractJavaRule {
    private List<ASTName> nameNodes = new ArrayList<ASTName>();
    private static final String FIND_THROWABLE_INSTANCE = "//VariableDeclaratorId[(../descendant::VariableInitializer/Expression/PrimaryExpression/PrimaryPrefix/AllocationExpression/ClassOrInterfaceType[contains(@Image,'Exception')and(not (../Arguments/ArgumentList))])]";
    private static final String ILLEGAL_STATE_EXCEPTION = "IllegalStateException";
    private static final String FILL_IN_STACKTRACE = ".fillInStackTrace";
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTClassOrInterfaceType;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTName;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTPrimaryPrefix;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTArgumentList;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTCastExpression;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTThrowStatement;

    public Object visit(ASTCatchStatement catchStmt, Object data) {
        String target = ((SimpleNode)catchStmt.jjtGetChild(0).jjtGetChild(1)).getImage();
        this.gatherVariableWithExceptionRef(catchStmt, data);
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTThrowStatement;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTThrowStatement = new ASTThrowStatement[0].getClass().getComponentType();
        }
        List lstThrowStatements = catchStmt.findChildrenOfType(clazz);
        Iterator i$ = lstThrowStatements.iterator();
        while (i$.hasNext()) {
            Node child;
            ASTArgumentList args;
            ASTThrowStatement throwStatement = (ASTThrowStatement)i$.next();
            Node n = throwStatement.jjtGetChild(0).jjtGetChild(0);
            Class<?> clazz2 = n.getClass();
            Class<?> clazz3 = class$net$sourceforge$pmd$ast$ASTCastExpression;
            if (clazz3 == null) {
                clazz3 = new ASTCastExpression[0].getClass().getComponentType();
            }
            if (clazz2.equals(clazz3)) {
                ASTPrimaryExpression expr = (ASTPrimaryExpression)n.jjtGetChild(1);
                if (expr.jjtGetNumChildren() <= 1) continue;
                Class<?> clazz4 = expr.jjtGetChild(1).getClass();
                Class<?> clazz5 = class$net$sourceforge$pmd$ast$ASTPrimaryPrefix;
                if (clazz5 == null) {
                    clazz5 = new ASTPrimaryPrefix[0].getClass().getComponentType();
                }
                if (!clazz4.equals(clazz5)) continue;
                RuleContext ctx = (RuleContext)data;
                this.addViolation(ctx, throwStatement);
                continue;
            }
            if (this.isThrownExceptionOfType(throwStatement, ILLEGAL_STATE_EXCEPTION)) continue;
            Class<?> clazz6 = class$net$sourceforge$pmd$ast$ASTArgumentList;
            if (clazz6 == null) {
                clazz6 = new ASTArgumentList[0].getClass().getComponentType();
            }
            if ((args = (ASTArgumentList)throwStatement.getFirstChildOfType(clazz6)) != null) {
                this.ck(data, target, throwStatement, args);
                continue;
            }
            for (child = throwStatement.jjtGetChild(0); child != null && child.jjtGetNumChildren() > 0; child = child.jjtGetChild(0)) {
                Class<?> clazz7 = child.getClass();
                Class<?> clazz8 = class$net$sourceforge$pmd$ast$ASTName;
                if (clazz8 == null) {
                    clazz8 = new ASTName[0].getClass().getComponentType();
                }
                if (clazz7.equals(clazz8)) break;
            }
            if (child == null) continue;
            Class<?> clazz9 = child.getClass();
            Class<?> clazz10 = class$net$sourceforge$pmd$ast$ASTName;
            if (clazz10 == null) {
                clazz10 = new ASTName[0].getClass().getComponentType();
            }
            if (clazz9.equals(clazz10) && !target.equals(((SimpleNode)child).getImage()) && !((SimpleNode)child).hasImageEqualTo(target + FILL_IN_STACKTRACE)) {
                Map<VariableNameDeclaration, List<NameOccurrence>> vars = ((ASTName)child).getScope().getVariableDeclarations();
                Iterator<VariableNameDeclaration> i$2 = vars.keySet().iterator();
                while (i$2.hasNext()) {
                    VariableNameDeclaration decl = i$2.next();
                    SimpleNode simpleNode = (SimpleNode)decl.getNode().jjtGetParent();
                    Class<?> clazz11 = class$net$sourceforge$pmd$ast$ASTArgumentList;
                    if (clazz11 == null) {
                        clazz11 = new ASTArgumentList[0].getClass().getComponentType();
                    }
                    if ((args = (ASTArgumentList)simpleNode.getFirstChildOfType(clazz11)) == null) continue;
                    this.ck(data, target, throwStatement, args);
                }
                continue;
            }
            Class<?> clazz12 = child.getClass();
            Class<?> clazz13 = class$net$sourceforge$pmd$ast$ASTClassOrInterfaceType;
            if (clazz13 == null) {
                clazz13 = new ASTClassOrInterfaceType[0].getClass().getComponentType();
            }
            if (!clazz12.equals(clazz13)) continue;
            this.addViolation(data, throwStatement);
        }
        return super.visit(catchStmt, data);
    }

    private void gatherVariableWithExceptionRef(ASTCatchStatement catchStmt, Object data) {
        try {
            List nodes = catchStmt.findChildNodesWithXPath(FIND_THROWABLE_INSTANCE);
            Iterator i$ = nodes.iterator();
            while (i$.hasNext()) {
                Node node = (Node)i$.next();
                List violations = catchStmt.findChildNodesWithXPath("//Expression/PrimaryExpression/PrimaryPrefix/Name[@Image = '" + ((SimpleNode)node).getImage() + "']");
                if (violations == null || violations.size() <= 0 || this.useInitCause((Node)violations.get(0), catchStmt)) continue;
                super.addViolation(data, (SimpleNode)node);
            }
        }
        catch (JaxenException e) {
            e.printStackTrace();
        }
    }

    private boolean useInitCause(Node node, ASTCatchStatement catchStmt) throws JaxenException {
        List nodes;
        return node != null && ((SimpleNode)node).getImage() != null && (nodes = catchStmt.findChildNodesWithXPath("descendant::StatementExpression/PrimaryExpression/PrimaryPrefix/Name[@Image = '" + ((SimpleNode)node).getImage() + ".initCause']")) != null && nodes.size() > 0;
    }

    private boolean isThrownExceptionOfType(ASTThrowStatement throwStatement, String type) {
        boolean status = false;
        try {
            List results = throwStatement.findChildNodesWithXPath("Expression/PrimaryExpression/PrimaryPrefix/AllocationExpression/ClassOrInterfaceType[@Image = '" + type + "']");
            if (results != null && results.size() == 1) {
                status = true;
            }
        }
        catch (JaxenException e) {
            e.printStackTrace();
        }
        return status;
    }

    private void ck(Object data, String target, ASTThrowStatement throwStatement, ASTArgumentList args) {
        boolean match = false;
        this.nameNodes.clear();
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTName;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTName = new ASTName[0].getClass().getComponentType();
        }
        args.findChildrenOfType(clazz, this.nameNodes);
        Iterator<ASTName> i$ = this.nameNodes.iterator();
        while (i$.hasNext()) {
            ASTName nameNode = i$.next();
            if (!target.equals(nameNode.getImage())) continue;
            match = true;
            break;
        }
        if (!match) {
            RuleContext ctx = (RuleContext)data;
            this.addViolation(ctx, throwStatement);
        }
    }
}

