/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules.design;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.ast.ASTAssignmentOperator;
import net.sourceforge.pmd.ast.ASTCompilationUnit;
import net.sourceforge.pmd.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.ast.ASTIfStatement;
import net.sourceforge.pmd.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.ast.ASTName;
import net.sourceforge.pmd.ast.ASTNullLiteral;
import net.sourceforge.pmd.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.ast.ASTStatementExpression;
import net.sourceforge.pmd.ast.ASTSynchronizedStatement;
import net.sourceforge.pmd.properties.BooleanProperty;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NonThreadSafeSingleton
extends AbstractRule {
    private Map<String, ASTFieldDeclaration> fieldDecls = new HashMap<String, ASTFieldDeclaration>();
    private boolean checkNonStaticMethods = true;
    private boolean checkNonStaticFields = true;
    private static final PropertyDescriptor checkNonStaticMethodsDescriptor = new BooleanProperty("checkNonStaticMethods", "Check for non-static methods.", true, 1.0f);
    private static final PropertyDescriptor checkNonStaticFieldsDescriptor = new BooleanProperty("checkNonStaticFields", "Check for non-static fields.", true, 2.0f);
    private static final Map<String, PropertyDescriptor> propertyDescriptorsByName = NonThreadSafeSingleton.asFixedMap(new PropertyDescriptor[]{checkNonStaticMethodsDescriptor, checkNonStaticFieldsDescriptor});
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTIfStatement;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTStatementExpression;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTName;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTSynchronizedStatement;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTPrimaryPrefix;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTPrimarySuffix;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTNullLiteral;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTAssignmentOperator;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTPrimaryExpression;

    @Override
    public Object visit(ASTCompilationUnit node, Object data) {
        this.fieldDecls.clear();
        this.checkNonStaticMethods = this.getBooleanProperty(checkNonStaticMethodsDescriptor);
        this.checkNonStaticFields = this.getBooleanProperty(checkNonStaticFieldsDescriptor);
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTFieldDeclaration node, Object data) {
        if (this.checkNonStaticFields || node.isStatic()) {
            this.fieldDecls.put(node.getVariableName(), node);
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTMethodDeclaration node, Object data) {
        if (this.checkNonStaticMethods && !node.isStatic() || node.isSynchronized()) {
            return super.visit(node, data);
        }
        Class<?> clazz = class$net$sourceforge$pmd$ast$ASTIfStatement;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$ast$ASTIfStatement = new ASTIfStatement[0].getClass().getComponentType();
        }
        List ifStatements = node.findChildrenOfType(clazz);
        for (ASTIfStatement ifStatement : ifStatements) {
            ASTName Name;
            ASTNullLiteral NullLiteral;
            Class<?> clazz2 = class$net$sourceforge$pmd$ast$ASTSynchronizedStatement;
            if (clazz2 == null) {
                clazz2 = new ASTSynchronizedStatement[0].getClass().getComponentType();
            }
            if (ifStatement.getFirstParentOfType(clazz2) != null) continue;
            Class<?> clazz3 = class$net$sourceforge$pmd$ast$ASTNullLiteral;
            if (clazz3 == null) {
                clazz3 = new ASTNullLiteral[0].getClass().getComponentType();
            }
            if ((NullLiteral = (ASTNullLiteral)ifStatement.getFirstChildOfType(clazz3)) == null) continue;
            Class<?> clazz4 = class$net$sourceforge$pmd$ast$ASTName;
            if (clazz4 == null) {
                clazz4 = new ASTName[0].getClass().getComponentType();
            }
            if ((Name = (ASTName)ifStatement.getFirstChildOfType(clazz4)) == null || !this.fieldDecls.containsKey(Name.getImage())) continue;
            Class<?> clazz5 = class$net$sourceforge$pmd$ast$ASTAssignmentOperator;
            if (clazz5 == null) {
                clazz5 = new ASTAssignmentOperator[0].getClass().getComponentType();
            }
            List assigmnents = ifStatement.findChildrenOfType(clazz5);
            boolean violation = false;
            for (int ix = 0; ix < assigmnents.size(); ++ix) {
                ASTAssignmentOperator oper = (ASTAssignmentOperator)assigmnents.get(ix);
                Class<?> clazz6 = oper.jjtGetParent().getClass();
                Class<?> clazz7 = class$net$sourceforge$pmd$ast$ASTStatementExpression;
                if (clazz7 == null) {
                    clazz7 = new ASTStatementExpression[0].getClass().getComponentType();
                }
                if (!clazz6.equals(clazz7)) continue;
                ASTStatementExpression expr = (ASTStatementExpression)oper.jjtGetParent();
                Class<?> clazz8 = expr.jjtGetChild(0).getClass();
                Class<?> clazz9 = class$net$sourceforge$pmd$ast$ASTPrimaryExpression;
                if (clazz9 == null) {
                    clazz9 = new ASTPrimaryExpression[0].getClass().getComponentType();
                }
                if (!clazz8.equals(clazz9)) continue;
                Class<?> clazz10 = ((ASTPrimaryExpression)expr.jjtGetChild(0)).jjtGetChild(0).getClass();
                Class<?> clazz11 = class$net$sourceforge$pmd$ast$ASTPrimaryPrefix;
                if (clazz11 == null) {
                    clazz11 = new ASTPrimaryPrefix[0].getClass().getComponentType();
                }
                if (!clazz10.equals(clazz11)) continue;
                ASTPrimaryPrefix pp = (ASTPrimaryPrefix)((ASTPrimaryExpression)expr.jjtGetChild(0)).jjtGetChild(0);
                String name = null;
                if (pp.usesThisModifier()) {
                    Class<?> clazz12 = class$net$sourceforge$pmd$ast$ASTPrimarySuffix;
                    if (clazz12 == null) {
                        clazz12 = new ASTPrimarySuffix[0].getClass().getComponentType();
                    }
                    ASTPrimarySuffix priSuf = (ASTPrimarySuffix)expr.getFirstChildOfType(clazz12);
                    name = priSuf.getImage();
                } else {
                    ASTName astName = (ASTName)pp.jjtGetChild(0);
                    name = astName.getImage();
                }
                if (!this.fieldDecls.containsKey(name)) continue;
                violation = true;
            }
            if (!violation) continue;
            this.addViolation(data, ifStatement);
        }
        return super.visit(node, data);
    }

    @Override
    protected Map<String, PropertyDescriptor> propertiesByName() {
        return propertyDescriptorsByName;
    }
}

