/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import edu.emory.mathcs.backport.java.util.concurrent.Callable;
import edu.emory.mathcs.backport.java.util.concurrent.ExecutionException;
import edu.emory.mathcs.backport.java.util.concurrent.ExecutorService;
import edu.emory.mathcs.backport.java.util.concurrent.Executors;
import edu.emory.mathcs.backport.java.util.concurrent.Future;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadFactory;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicInteger;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.sourceforge.pmd.CommandLineOptions;
import net.sourceforge.pmd.DataSource;
import net.sourceforge.pmd.FileDataSource;
import net.sourceforge.pmd.Language;
import net.sourceforge.pmd.PMDException;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleSetFactory;
import net.sourceforge.pmd.RuleSetNotFoundException;
import net.sourceforge.pmd.RuleSets;
import net.sourceforge.pmd.SourceFileSelector;
import net.sourceforge.pmd.SourceType;
import net.sourceforge.pmd.SourceTypeDiscoverer;
import net.sourceforge.pmd.SourceTypeToRuleLanguageMapper;
import net.sourceforge.pmd.ZipDataSource;
import net.sourceforge.pmd.ast.CompilationUnit;
import net.sourceforge.pmd.ast.ParseException;
import net.sourceforge.pmd.cpd.FileFinder;
import net.sourceforge.pmd.cpd.SourceFileOrDirectoryFilter;
import net.sourceforge.pmd.parsers.Parser;
import net.sourceforge.pmd.renderers.Renderer;
import net.sourceforge.pmd.sourcetypehandlers.SourceTypeHandler;
import net.sourceforge.pmd.sourcetypehandlers.SourceTypeHandlerBroker;
import net.sourceforge.pmd.util.Benchmark;
import net.sourceforge.pmd.util.ConsoleLogHandler;
import net.sourceforge.retroweaver.runtime.java.lang.System_;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PMD {
    public static final String EOL = System.getProperty("line.separator", "\n");
    public static final String VERSION = "4.1";
    public static final String EXCLUDE_MARKER = "NOPMD";
    private static final Logger LOG;
    private String excludeMarker = "NOPMD";
    private SourceTypeDiscoverer sourceTypeDiscoverer = new SourceTypeDiscoverer();
    private static final boolean mtSupported;
    private static final /* synthetic */ Class class$net$sourceforge$pmd$PMD;

    public void processFile(Reader reader, RuleSets ruleSets, RuleContext ctx) throws PMDException {
        SourceType sourceType = this.getSourceTypeOfFile(ctx.getSourceCodeFilename());
        this.processFile(reader, ruleSets, ctx, sourceType);
    }

    public void processFile(Reader reader, RuleSets ruleSets, RuleContext ctx, SourceType sourceType) throws PMDException {
        try {
            SourceTypeHandler sourceTypeHandler = SourceTypeHandlerBroker.getVisitorsFactoryForSourceType(sourceType);
            ctx.setSourceType(sourceType);
            Parser parser = sourceTypeHandler.getParser();
            parser.setExcludeMarker(this.excludeMarker);
            long start = System_.nanoTime();
            CompilationUnit rootNode = (CompilationUnit)parser.parse(reader);
            ctx.excludeLines(parser.getExcludeMap());
            long end = System_.nanoTime();
            Benchmark.mark(4, end - start, 0L);
            start = System_.nanoTime();
            sourceTypeHandler.getSymbolFacade().start(rootNode);
            end = System_.nanoTime();
            Benchmark.mark(5, end - start, 0L);
            Language language = SourceTypeToRuleLanguageMapper.getMappedLanguage(sourceType);
            if (ruleSets.usesDFA(language)) {
                start = System_.nanoTime();
                sourceTypeHandler.getDataFlowFacade().start(rootNode);
                end = System_.nanoTime();
                Benchmark.mark(6, end - start, 0L);
            }
            if (ruleSets.usesTypeResolution(language)) {
                start = System_.nanoTime();
                sourceTypeHandler.getTypeResolutionFacade().start(rootNode);
                end = System_.nanoTime();
                Benchmark.mark(7, end - start, 0L);
            }
            ArrayList<CompilationUnit> acus = new ArrayList<CompilationUnit>();
            acus.add(rootNode);
            ruleSets.apply(acus, ctx, language);
        }
        catch (ParseException pe) {
            throw new PMDException(new StringBuffer().append("Error while parsing ").append(ctx.getSourceCodeFilename()).toString(), pe);
        }
        catch (Exception e) {
            throw new PMDException(new StringBuffer().append("Error while processing ").append(ctx.getSourceCodeFilename()).toString(), e);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {}
        }
    }

    private SourceType getSourceTypeOfFile(String fileName) {
        SourceType sourceType = this.sourceTypeDiscoverer.getSourceTypeOfFile(fileName);
        if (sourceType == null) {
            sourceType = this.sourceTypeDiscoverer.getSourceTypeOfJavaFiles();
        }
        return sourceType;
    }

    public void processFile(Reader reader, RuleSet ruleSet, RuleContext ctx) throws PMDException {
        this.processFile(reader, new RuleSets(ruleSet), ctx);
    }

    public void processFile(InputStream fileContents, String encoding, RuleSet ruleSet, RuleContext ctx) throws PMDException {
        try {
            this.processFile((Reader)new InputStreamReader(fileContents, encoding), ruleSet, ctx);
        }
        catch (UnsupportedEncodingException uee) {
            throw new PMDException(new StringBuffer().append("Unsupported encoding exception: ").append(uee.getMessage()).toString());
        }
    }

    public void processFile(InputStream fileContents, String encoding, RuleSets ruleSets, RuleContext ctx) throws PMDException {
        try {
            this.processFile((Reader)new InputStreamReader(fileContents, encoding), ruleSets, ctx);
        }
        catch (UnsupportedEncodingException uee) {
            throw new PMDException(new StringBuffer().append("Unsupported encoding exception: ").append(uee.getMessage()).toString());
        }
    }

    public void processFile(InputStream fileContents, RuleSet ruleSet, RuleContext ctx) throws PMDException {
        this.processFile(fileContents, System.getProperty("file.encoding"), ruleSet, ctx);
    }

    public void setExcludeMarker(String marker) {
        this.excludeMarker = marker;
    }

    public void setJavaVersion(SourceType javaVersion) {
        this.sourceTypeDiscoverer.setSourceTypeOfJavaFiles(javaVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        SourceType sourceType;
        long start = System_.nanoTime();
        CommandLineOptions opts = new CommandLineOptions(args);
        PMD.initializeLogger(opts.debugEnabled());
        long startFiles = System_.nanoTime();
        SourceFileSelector fileSelector = new SourceFileSelector();
        fileSelector.setSelectJavaFiles(opts.isCheckJavaFiles());
        fileSelector.setSelectJspFiles(opts.isCheckJspFiles());
        List<DataSource> files = opts.containsCommaSeparatedFileList() ? PMD.collectFromCommaDelimitedString(opts.getInputPath(), fileSelector) : PMD.collectFilesFromOneName(opts.getInputPath(), fileSelector);
        long endFiles = System_.nanoTime();
        Benchmark.mark(2, endFiles - startFiles, 0L);
        if (opts.getTargetJDK().equals("1.3")) {
            LOG.fine("In JDK 1.3 mode");
            sourceType = SourceType.JAVA_13;
        } else if (opts.getTargetJDK().equals("1.5")) {
            LOG.fine("In JDK 1.5 mode");
            sourceType = SourceType.JAVA_15;
        } else if (opts.getTargetJDK().equals("1.6")) {
            LOG.fine("In JDK 1.6 mode");
            sourceType = SourceType.JAVA_16;
        } else if (opts.getTargetJDK().equals("1.7")) {
            LOG.fine("In JDK 1.7 mode");
            sourceType = SourceType.JAVA_17;
        } else {
            LOG.fine("In JDK 1.4 mode");
            sourceType = SourceType.JAVA_14;
        }
        Writer w = null;
        long reportStart = System_.nanoTime();
        try {
            Renderer renderer = opts.createRenderer();
            LinkedList<Renderer> renderers = new LinkedList<Renderer>();
            renderers.add(renderer);
            w = opts.getReportFile() != null ? new BufferedWriter(new FileWriter(opts.getReportFile())) : new OutputStreamWriter(System.out);
            renderer.setWriter(w);
            renderer.start();
            long reportEnd = System_.nanoTime();
            Benchmark.mark(9, reportEnd - reportStart, 0L);
            RuleContext ctx = new RuleContext();
            try {
                long startLoadRules = System_.nanoTime();
                RuleSetFactory ruleSetFactory = new RuleSetFactory();
                ruleSetFactory.setMinimumPriority(opts.getMinPriority());
                RuleSets rulesets = ruleSetFactory.createRuleSets(opts.getRulesets());
                PMD.printRuleNamesInDebug(rulesets);
                long endLoadRules = System_.nanoTime();
                Benchmark.mark(3, endLoadRules - startLoadRules, 0L);
                PMD.processFiles(opts.getCpus(), ruleSetFactory, sourceType, files, ctx, renderers, opts.stressTestEnabled(), opts.getRulesets(), opts.shortNamesEnabled(), opts.getInputPath(), opts.getEncoding(), opts.getExcludeMarker());
            }
            catch (RuleSetNotFoundException rsnfe) {
                LOG.log(Level.SEVERE, "Ruleset not found", rsnfe);
                System.out.println(opts.usage());
            }
            reportStart = System_.nanoTime();
            renderer.end();
            w.write(EOL);
            w.flush();
            if (opts.getReportFile() != null) {
                w.close();
                w = null;
            }
        }
        catch (Exception e) {
            LOG.severe(e.getMessage());
            LOG.log(Level.FINE, "Exception during processing", e);
            LOG.info(opts.usage());
        }
        finally {
            if (opts.getReportFile() != null && w != null) {
                try {
                    w.close();
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
            }
            long reportEnd = System_.nanoTime();
            Benchmark.mark(9, reportEnd - reportStart, 0L);
        }
        if (opts.benchmark()) {
            long end = System_.nanoTime();
            Benchmark.mark(14, end - start, 0L);
            System.err.println(Benchmark.report());
        }
    }

    private static void initializeLogger(boolean debugEnabled) {
        Logger rootLogger = Logger.getLogger("");
        rootLogger.removeHandler(rootLogger.getHandlers()[0]);
        rootLogger.addHandler(new ConsoleLogHandler());
        if (debugEnabled) {
            rootLogger.setLevel(Level.FINER);
            LOG.setLevel(Level.FINER);
        } else {
            rootLogger.setLevel(Level.INFO);
            LOG.setLevel(Level.INFO);
        }
    }

    public static void processFiles(int threadCount, RuleSetFactory ruleSetFactory, SourceType sourceType, List<DataSource> files, RuleContext ctx, List<Renderer> renderers, String rulesets, boolean shortNamesEnabled, String inputPath, String encoding, String excludeMarker) {
        PMD.processFiles(threadCount, ruleSetFactory, sourceType, files, ctx, renderers, false, rulesets, shortNamesEnabled, inputPath, encoding, excludeMarker);
    }

    public static void processFiles(int threadCount, RuleSetFactory ruleSetFactory, SourceType sourceType, List<DataSource> files, RuleContext ctx, List<Renderer> renderers, boolean stressTestEnabled, String rulesets, final boolean shortNamesEnabled, final String inputPath, String encoding, String excludeMarker) {
        boolean useMT;
        boolean bl = useMT = mtSupported && threadCount > 0;
        if (stressTestEnabled) {
            Collections.shuffle(files);
        } else {
            Collections.sort(files, new Comparator<DataSource>(){

                @Override
                public int compare(DataSource d1, DataSource d2) {
                    String s1 = d1.getNiceFileName(shortNamesEnabled, inputPath);
                    String s2 = d2.getNiceFileName(shortNamesEnabled, inputPath);
                    return s1.compareTo(s2);
                }
            });
        }
        if (useMT) {
            PmdThreadFactory factory = new PmdThreadFactory(ruleSetFactory);
            ExecutorService executor = Executors.newFixedThreadPool((int)threadCount, (ThreadFactory)factory);
            LinkedList<Future> tasks = new LinkedList<Future>();
            for (DataSource dataSource : files) {
                String niceFileName = dataSource.getNiceFileName(shortNamesEnabled, inputPath);
                PmdRunnable r = new PmdRunnable(executor, dataSource, niceFileName, sourceType, renderers, encoding, rulesets, excludeMarker);
                Future future = executor.submit((Callable)r);
                tasks.add(future);
            }
            executor.shutdown();
            while (!tasks.isEmpty()) {
                Future future = (Future)tasks.remove(0);
                Report report = null;
                try {
                    report = (Report)future.get();
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    future.cancel(true);
                }
                catch (ExecutionException ee) {
                    Throwable t = ee.getCause();
                    if (t instanceof RuntimeException) {
                        throw (RuntimeException)t;
                    }
                    if (t instanceof Error) {
                        throw (Error)t;
                    }
                    throw new IllegalStateException("PmdRunnable exception", t);
                }
                try {
                    long start = System_.nanoTime();
                    for (Renderer r : renderers) {
                        r.renderFileReport(report);
                    }
                    long end = System_.nanoTime();
                    Benchmark.mark(9, end - start, 1L);
                }
                catch (IOException ioe) {}
            }
        } else {
            PMD pmd = new PMD();
            pmd.setJavaVersion(sourceType);
            pmd.setExcludeMarker(excludeMarker);
            RuleSets rs = null;
            try {
                rs = ruleSetFactory.createRuleSets(rulesets);
            }
            catch (RuleSetNotFoundException rsnfe) {
                // empty catch block
            }
            for (DataSource dataSource : files) {
                String niceFileName = dataSource.getNiceFileName(shortNamesEnabled, inputPath);
                Report report = new Report();
                ctx.setReport(report);
                ctx.setSourceCodeFilename(niceFileName);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine(new StringBuffer().append("Processing ").append(ctx.getSourceCodeFilename()).toString());
                }
                for (Renderer r : renderers) {
                    r.startFileAnalysis(dataSource);
                }
                try {
                    BufferedInputStream stream = new BufferedInputStream(dataSource.getInputStream());
                    pmd.processFile((InputStream)stream, encoding, rs, ctx);
                }
                catch (PMDException pmde) {
                    LOG.log(Level.FINE, "Error while processing file", pmde.getCause());
                    report.addError(new Report.ProcessingError(pmde.getMessage(), niceFileName));
                }
                catch (IOException ioe) {
                    LOG.log(Level.FINE, "Unable to read source file", ioe);
                    report.addError(new Report.ProcessingError(ioe.getMessage(), niceFileName));
                }
                catch (RuntimeException re) {
                    LOG.log(Level.FINE, "RuntimeException while processing file", re);
                    report.addError(new Report.ProcessingError(re.getMessage(), niceFileName));
                }
                try {
                    long start = System_.nanoTime();
                    for (Renderer r : renderers) {
                        r.renderFileReport(report);
                    }
                    long end = System_.nanoTime();
                    Benchmark.mark(9, end - start, 1L);
                }
                catch (IOException ioe) {}
            }
        }
    }

    public void processFiles(List<DataSource> files, RuleContext ctx, RuleSets rulesets, boolean debugEnabled, boolean shortNamesEnabled, String inputPath, String encoding) throws IOException {
        for (DataSource dataSource : files) {
            String niceFileName = dataSource.getNiceFileName(shortNamesEnabled, inputPath);
            ctx.setSourceCodeFilename(niceFileName);
            LOG.fine(new StringBuffer().append("Processing ").append(ctx.getSourceCodeFilename()).toString());
            try {
                BufferedInputStream stream = new BufferedInputStream(dataSource.getInputStream());
                this.processFile((InputStream)stream, encoding, rulesets, ctx);
            }
            catch (PMDException pmde) {
                LOG.log(Level.FINE, "Error while processing files", pmde.getCause());
                ctx.getReport().addError(new Report.ProcessingError(pmde.getMessage(), niceFileName));
            }
        }
    }

    private static void printRuleNamesInDebug(RuleSets rulesets) {
        if (LOG.isLoggable(Level.FINER)) {
            for (Rule r : rulesets.getAllRules()) {
                LOG.finer(new StringBuffer().append("Loaded rule ").append(r.getName()).toString());
            }
        }
    }

    private static List<DataSource> collectFilesFromOneName(String inputFileName, SourceFileSelector fileSelector) {
        return PMD.collect(inputFileName, fileSelector);
    }

    private static List<DataSource> collectFromCommaDelimitedString(String fileList, SourceFileSelector fileSelector) {
        ArrayList<DataSource> files = new ArrayList<DataSource>();
        StringTokenizer st = new StringTokenizer(fileList, ",");
        while (st.hasMoreTokens()) {
            files.addAll(PMD.collect(st.nextToken(), fileSelector));
        }
        return files;
    }

    private static List<DataSource> collect(String filename, SourceFileSelector fileSelector) {
        File inputFile = new File(filename);
        if (!inputFile.exists()) {
            throw new RuntimeException(new StringBuffer().append("File ").append(inputFile.getName()).append(" doesn't exist").toString());
        }
        ArrayList<DataSource> dataSources = new ArrayList<DataSource>();
        if (!inputFile.isDirectory()) {
            if (filename.endsWith(".zip") || filename.endsWith(".jar")) {
                try {
                    ZipFile zipFile = new ZipFile(inputFile);
                    Enumeration<? extends ZipEntry> e = zipFile.entries();
                    while (e.hasMoreElements()) {
                        ZipEntry zipEntry = e.nextElement();
                        if (!fileSelector.isWantedFile(zipEntry.getName())) continue;
                        dataSources.add(new ZipDataSource(zipFile, zipEntry));
                    }
                }
                catch (IOException ze) {
                    throw new RuntimeException(new StringBuffer().append("Zip file ").append(inputFile.getName()).append(" can't be opened").toString());
                }
            } else {
                dataSources.add(new FileDataSource(inputFile));
            }
        } else {
            FileFinder finder = new FileFinder();
            List<File> files = finder.findFilesFrom(inputFile.getAbsolutePath(), new SourceFileOrDirectoryFilter(fileSelector), true);
            for (File f : files) {
                dataSources.add(new FileDataSource(f));
            }
        }
        return dataSources;
    }

    static {
        Class<?> clazz = class$net$sourceforge$pmd$PMD;
        if (clazz == null) {
            clazz = class$net$sourceforge$pmd$PMD = new PMD[0].getClass().getComponentType();
        }
        LOG = Logger.getLogger(clazz.getName());
        boolean error = false;
        try {
            ExecutorService executor = Executors.newFixedThreadPool((int)1);
            executor.shutdown();
        }
        catch (RuntimeException e) {
            error = true;
        }
        mtSupported = !error;
    }

    private static class PmdThread
    extends Thread {
        private int id;
        private RuleContext context;
        private RuleSets rulesets;
        private RuleSetFactory ruleSetFactory;

        public PmdThread(int id, Runnable r, RuleSetFactory ruleSetFactory) {
            super(r, "PmdThread " + id);
            this.id = id;
            this.context = new RuleContext();
            this.ruleSetFactory = ruleSetFactory;
        }

        public RuleContext getRuleContext() {
            return this.context;
        }

        public RuleSets getRuleSets(String rsList) {
            if (this.rulesets == null) {
                try {
                    this.rulesets = this.ruleSetFactory.createRuleSets(rsList);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return this.rulesets;
        }

        public String toString() {
            return "PmdThread " + this.id;
        }
    }

    private static class PmdThreadFactory
    implements ThreadFactory {
        private final RuleSetFactory ruleSetFactory;
        private final AtomicInteger counter = new AtomicInteger();
        public List<PmdThread> threadList = Collections.synchronizedList(new LinkedList());

        public PmdThreadFactory(RuleSetFactory ruleSetFactory) {
            this.ruleSetFactory = ruleSetFactory;
        }

        public Thread newThread(Runnable r) {
            PmdThread t = new PmdThread(this.counter.incrementAndGet(), r, this.ruleSetFactory);
            this.threadList.add(t);
            return t;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PmdRunnable
    extends PMD
    implements Callable<Report> {
        private final ExecutorService executor;
        private final DataSource dataSource;
        private final String fileName;
        private final String encoding;
        private final String rulesets;
        private final List<Renderer> renderers;

        public PmdRunnable(ExecutorService executor, DataSource dataSource, String fileName, SourceType sourceType, List<Renderer> renderers, String encoding, String rulesets, String excludeMarker) {
            this.executor = executor;
            this.dataSource = dataSource;
            this.fileName = fileName;
            this.encoding = encoding;
            this.rulesets = rulesets;
            this.renderers = renderers;
            this.setJavaVersion(sourceType);
            this.setExcludeMarker(excludeMarker);
        }

        public Report call() {
            PmdThread thread = (PmdThread)Thread.currentThread();
            RuleContext ctx = thread.getRuleContext();
            RuleSets rs = thread.getRuleSets(this.rulesets);
            Report report = new Report();
            ctx.setReport(report);
            ctx.setSourceCodeFilename(this.fileName);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(new StringBuffer().append("Processing ").append(ctx.getSourceCodeFilename()).toString());
            }
            for (Renderer r : this.renderers) {
                r.startFileAnalysis(this.dataSource);
            }
            try {
                BufferedInputStream stream = new BufferedInputStream(this.dataSource.getInputStream());
                this.processFile((InputStream)stream, this.encoding, rs, ctx);
            }
            catch (PMDException pmde) {
                LOG.log(Level.FINE, "Error while processing file", pmde.getCause());
                report.addError(new Report.ProcessingError(pmde.getMessage(), this.fileName));
            }
            catch (IOException ioe) {
                LOG.log(Level.FINE, "IOException during processing", ioe);
                report.addError(new Report.ProcessingError(ioe.getMessage(), this.fileName));
                this.executor.shutdownNow();
            }
            catch (RuntimeException re) {
                LOG.log(Level.FINE, "RuntimeException during processing", re);
                report.addError(new Report.ProcessingError(re.getMessage(), this.fileName));
                this.executor.shutdownNow();
            }
            return report;
        }
    }
}

