/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation.validator.resolver;

import io.micronaut.context.annotation.Primary;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.CollectionUtils;
import java.lang.annotation.ElementType;
import java.util.List;
import javax.inject.Singleton;
import javax.validation.Path;
import javax.validation.TraversableResolver;

@Primary
@Singleton
@Internal
public class CompositeTraversableResolver
implements TraversableResolver {
    private final List<TraversableResolver> traversableResolvers;

    public CompositeTraversableResolver(List<TraversableResolver> traversableResolvers) {
        this.traversableResolvers = CollectionUtils.isEmpty(traversableResolvers) ? null : traversableResolvers;
    }

    @Override
    public boolean isReachable(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
        if (this.traversableResolvers == null) {
            return true;
        }
        return this.traversableResolvers.stream().allMatch(r -> r.isReachable(traversableObject, traversableProperty, rootBeanType, pathToTraversableObject, elementType));
    }

    @Override
    public boolean isCascadable(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
        if (this.traversableResolvers == null) {
            return true;
        }
        return this.traversableResolvers.stream().allMatch(r -> r.isCascadable(traversableObject, traversableProperty, rootBeanType, pathToTraversableObject, elementType));
    }
}

