/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation.validator;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.type.Argument;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.ConstraintTarget;
import javax.validation.ConstraintValidator;
import javax.validation.Payload;
import javax.validation.metadata.ConstraintDescriptor;
import javax.validation.metadata.ValidateUnwrappedValue;

@Internal
class DefaultConstraintDescriptor<T extends Annotation>
implements ConstraintDescriptor<T> {
    private final AnnotationValue<T> annotationValue;
    private final AnnotationMetadata annotationMetadata;
    private final Class<T> type;

    DefaultConstraintDescriptor(AnnotationMetadata annotationMetadata, Class<T> type, AnnotationValue<T> annotationValue) {
        this.annotationValue = annotationValue;
        this.annotationMetadata = annotationMetadata;
        this.type = type;
    }

    @Override
    public T getAnnotation() {
        return this.annotationMetadata.synthesize(this.type);
    }

    @Override
    public String getMessageTemplate() {
        return this.annotationValue.get("groups", String.class).orElse(null);
    }

    @Override
    public Set<Class<?>> getGroups() {
        Set<Class<?>> groups = this.annotationValue.get("groups", Argument.setOf(Class.class)).orElse(Collections.emptySet());
        return groups;
    }

    @Override
    public Set<Class<? extends Payload>> getPayload() {
        Set<Class<? extends Payload>> payload = this.annotationValue.get("payload", Argument.setOf(Class.class)).orElse(Collections.emptySet());
        return payload;
    }

    @Override
    public ConstraintTarget getValidationAppliesTo() {
        return ConstraintTarget.IMPLICIT;
    }

    @Override
    public List<Class<? extends ConstraintValidator<T, ?>>> getConstraintValidatorClasses() {
        return Collections.emptyList();
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.annotationValue.getValues().entrySet().stream().collect(Collectors.toMap(entry -> ((CharSequence)entry.getKey()).toString(), Map.Entry::getValue));
    }

    @Override
    public Set<ConstraintDescriptor<?>> getComposingConstraints() {
        return Collections.emptySet();
    }

    @Override
    public boolean isReportAsSingleViolation() {
        return false;
    }

    @Override
    public ValidateUnwrappedValue getValueUnwrapping() {
        return ValidateUnwrappedValue.DEFAULT;
    }

    @Override
    public Object unwrap(Class type) {
        throw new UnsupportedOperationException("Unwrapping unsupported");
    }
}

