/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.scheduling.executor;

import io.micronaut.context.BeanLocator;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.core.reflect.InstantiationUtils;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.scheduling.executor.ExecutorConfiguration;
import io.micronaut.scheduling.executor.ExecutorType;
import io.micronaut.scheduling.executor.NamedThreadFactory;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.inject.Inject;

@Factory
public class ExecutorFactory {
    private final BeanLocator beanLocator;
    private final ThreadFactory threadFactory;

    @Deprecated
    public ExecutorFactory(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
        this.beanLocator = null;
    }

    @Inject
    public ExecutorFactory(BeanLocator beanLocator, ThreadFactory threadFactory) {
        this.beanLocator = beanLocator;
        this.threadFactory = threadFactory;
    }

    @EachBean(value=ExecutorConfiguration.class)
    protected ThreadFactory eventLoopGroupThreadFactory(ExecutorConfiguration configuration) {
        return configuration.getName() == null ? this.threadFactory : new NamedThreadFactory(configuration.getName() + "-executor");
    }

    @EachBean(value=ExecutorConfiguration.class)
    @Bean(preDestroy="shutdown")
    public ExecutorService executorService(ExecutorConfiguration executorConfiguration) {
        ExecutorType executorType = executorConfiguration.getType();
        switch (executorType) {
            case FIXED: {
                return Executors.newFixedThreadPool(executorConfiguration.getNumberOfThreads(), this.getThreadFactory(executorConfiguration));
            }
            case CACHED: {
                return Executors.newCachedThreadPool(this.getThreadFactory(executorConfiguration));
            }
            case SCHEDULED: {
                return Executors.newScheduledThreadPool(executorConfiguration.getCorePoolSize(), this.getThreadFactory(executorConfiguration));
            }
            case WORK_STEALING: {
                return Executors.newWorkStealingPool(executorConfiguration.getParallelism());
            }
        }
        throw new IllegalStateException("Could not create Executor service for enum value: " + (Object)((Object)executorType));
    }

    private ThreadFactory getThreadFactory(ExecutorConfiguration executorConfiguration) {
        return executorConfiguration.getThreadFactoryClass().flatMap(InstantiationUtils::tryInstantiate).map(tf -> tf).orElseGet(() -> {
            if (this.beanLocator != null) {
                if (executorConfiguration.getName() == null) {
                    return this.beanLocator.getBean(ThreadFactory.class);
                }
                return this.beanLocator.getBean(ThreadFactory.class, Qualifiers.byName(executorConfiguration.getName()));
            }
            throw new IllegalStateException("No bean factory configured");
        });
    }
}

