/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.scheduling.executor;

import io.micronaut.context.BeanLocator;
import io.micronaut.context.BeanProvider;
import io.micronaut.context.exceptions.NoSuchBeanException;
import io.micronaut.core.annotation.Blocking;
import io.micronaut.core.annotation.NonBlocking;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.TypeInformation;
import io.micronaut.core.util.SupplierUtil;
import io.micronaut.inject.MethodReference;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.scheduling.annotation.ExecuteOn;
import io.micronaut.scheduling.exceptions.SchedulerConfigurationException;
import io.micronaut.scheduling.executor.ExecutorSelector;
import io.micronaut.scheduling.executor.ThreadSelection;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;

@Singleton
public class DefaultExecutorSelector
implements ExecutorSelector {
    private static final String EXECUTE_ON = ExecuteOn.class.getName();
    private final BeanLocator beanLocator;
    private final Supplier<ExecutorService> ioExecutor;

    @Deprecated
    protected DefaultExecutorSelector(BeanLocator beanLocator, @Named(value="io") Provider<ExecutorService> ioExecutor) {
        this.beanLocator = beanLocator;
        this.ioExecutor = SupplierUtil.memoized(ioExecutor::get);
    }

    @Inject
    protected DefaultExecutorSelector(BeanLocator beanLocator, @Named(value="io") BeanProvider<ExecutorService> ioExecutor) {
        this.beanLocator = beanLocator;
        this.ioExecutor = SupplierUtil.memoized(ioExecutor::get);
    }

    @Override
    public Optional<ExecutorService> select(MethodReference method, ThreadSelection threadSelection) {
        String name = method.stringValue(EXECUTE_ON).orElse(null);
        if (name != null) {
            try {
                ExecutorService executorService = this.beanLocator.getBean(ExecutorService.class, Qualifiers.byName(name));
                return Optional.of(executorService);
            }
            catch (NoSuchBeanException e) {
                throw new SchedulerConfigurationException(method, "No executor configured for name: " + name);
            }
        }
        if (threadSelection == ThreadSelection.AUTO) {
            Optional<Argument<?>> generic;
            if (method.hasStereotype((Class<? extends Annotation>)NonBlocking.class)) {
                return Optional.empty();
            }
            if (method.hasStereotype((Class<? extends Annotation>)Blocking.class)) {
                return Optional.of(this.ioExecutor.get());
            }
            TypeInformation<Object> returnType = method.getReturnType();
            if (returnType.isWrapperType() && (generic = method.getReturnType().getFirstTypeVariable()).isPresent()) {
                returnType = generic.get();
            }
            if (returnType.isAsyncOrReactive()) {
                return Optional.empty();
            }
            return Optional.of(this.ioExecutor.get());
        }
        if (threadSelection == ThreadSelection.IO) {
            return Optional.of(this.ioExecutor.get());
        }
        return Optional.empty();
    }
}

