/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.runtime.context.scope;

import io.micronaut.context.BeanResolutionContext;
import io.micronaut.context.LifeCycle;
import io.micronaut.context.scope.CustomScope;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.BeanIdentifier;
import io.micronaut.runtime.context.scope.ThreadLocal;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.inject.Provider;
import javax.inject.Singleton;

@Singleton
class ThreadLocalCustomScope
implements CustomScope<ThreadLocal>,
LifeCycle<ThreadLocalCustomScope> {
    private final java.lang.ThreadLocal<Map<String, Object>> threadScope = java.lang.ThreadLocal.withInitial(HashMap::new);

    ThreadLocalCustomScope() {
    }

    @Override
    public Class<ThreadLocal> annotationType() {
        return ThreadLocal.class;
    }

    @Override
    public <T> T get(BeanResolutionContext resolutionContext, BeanDefinition<T> beanDefinition, BeanIdentifier identifier, Provider<T> provider) {
        String key;
        Map<String, Object> values = this.threadScope.get();
        Object bean = values.get(key = identifier.toString());
        if (bean == null) {
            bean = provider.get();
            values.put(key, bean);
        }
        return (T)bean;
    }

    @Override
    public <T> Optional<T> remove(BeanIdentifier identifier) {
        Map<String, Object> values = this.threadScope.get();
        Object previous = values.remove(identifier.toString());
        return previous != null ? Optional.of(previous) : Optional.empty();
    }

    @Override
    public boolean isRunning() {
        return true;
    }

    @Override
    public ThreadLocalCustomScope start() {
        return this;
    }

    @Override
    public ThreadLocalCustomScope stop() {
        this.threadScope.remove();
        return this;
    }
}

