/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.reactive.rxjava2;

import io.micronaut.core.annotation.Internal;
import io.micronaut.reactive.rxjava2.RxInstrumentedComponent;
import io.micronaut.reactive.rxjava2.RxInstrumenterFactory;
import io.micronaut.scheduling.instrument.Instrumentation;
import io.micronaut.scheduling.instrument.InvocationInstrumenter;
import io.reactivex.SingleObserver;
import io.reactivex.disposables.Disposable;

@Internal
final class RxInstrumentedSingleObserver<T>
implements SingleObserver<T>,
RxInstrumentedComponent {
    private final SingleObserver<T> source;
    private final InvocationInstrumenter instrumenter;

    RxInstrumentedSingleObserver(SingleObserver<T> source, RxInstrumenterFactory instrumenterFactory) {
        this.source = source;
        this.instrumenter = instrumenterFactory.create();
    }

    @Override
    public void onSubscribe(Disposable d) {
        try (Instrumentation ignored = this.instrumenter.newInstrumentation();){
            this.source.onSubscribe(d);
        }
    }

    @Override
    public void onError(Throwable t) {
        try (Instrumentation ignored = this.instrumenter.newInstrumentation();){
            this.source.onError(t);
        }
    }

    @Override
    public void onSuccess(T value) {
        try (Instrumentation ignored = this.instrumenter.newInstrumentation();){
            this.source.onSuccess(value);
        }
    }
}

