/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.reactive.rxjava2;

import io.micronaut.core.annotation.Internal;
import io.micronaut.reactive.rxjava2.RxInstrumentedComponent;
import io.micronaut.reactive.rxjava2.RxInstrumentedWrappers;
import io.micronaut.reactive.rxjava2.RxInstrumenterFactory;
import io.micronaut.scheduling.instrument.Instrumentation;
import io.micronaut.scheduling.instrument.InvocationInstrumenter;
import io.reactivex.parallel.ParallelFlowable;
import org.reactivestreams.Subscriber;

@Internal
final class RxInstrumentedParallelFlowable<T>
extends ParallelFlowable<T>
implements RxInstrumentedComponent {
    protected final ParallelFlowable<T> source;
    private final RxInstrumenterFactory instrumenterFactory;
    private final InvocationInstrumenter instrumenter;

    RxInstrumentedParallelFlowable(ParallelFlowable<T> source, RxInstrumenterFactory instrumenterFactory) {
        this.source = source;
        this.instrumenterFactory = instrumenterFactory;
        this.instrumenter = instrumenterFactory.create();
    }

    @Override
    public int parallelism() {
        return this.source.parallelism();
    }

    @Override
    public void subscribe(Subscriber<? super T>[] s) {
        if (!this.validate(s)) {
            return;
        }
        InvocationInstrumenter instrumenter = this.instrumenter;
        if (instrumenter == null) {
            this.source.subscribe(s);
            return;
        }
        int n = s.length;
        Subscriber[] parents = new Subscriber[n];
        for (int i = 0; i < n; ++i) {
            Subscriber<? super T> z = s[i];
            parents[i] = RxInstrumentedWrappers.wrap(z, this.instrumenterFactory);
        }
        try (Instrumentation ignored = instrumenter.newInstrumentation();){
            this.source.subscribe(parents);
        }
    }
}

