/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jackson.convert;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ContainerNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.TypeConverter;
import io.micronaut.core.type.Argument;
import io.micronaut.jackson.JacksonConfiguration;
import java.io.IOException;
import java.util.Optional;
import javax.inject.Provider;

@Deprecated
public class JsonNodeToObjectConverter
implements TypeConverter<JsonNode, Object> {
    private final Provider<ObjectMapper> objectMapper;

    public JsonNodeToObjectConverter(Provider<ObjectMapper> objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public Optional<Object> convert(JsonNode node, Class<Object> targetType, ConversionContext context) {
        try {
            Object result;
            if (CharSequence.class.isAssignableFrom(targetType) && node instanceof ObjectNode) {
                return Optional.of(node.toString());
            }
            Argument argument = null;
            if (node instanceof ContainerNode && context instanceof ArgumentConversionContext && targetType.getTypeParameters().length != 0) {
                argument = ((ArgumentConversionContext)context).getArgument();
            }
            if (argument != null) {
                ObjectMapper om = this.objectMapper.get();
                JsonParser jsonParser = om.treeAsTokens(node);
                TypeFactory typeFactory = om.getTypeFactory();
                JavaType javaType = JacksonConfiguration.constructType(argument, typeFactory);
                result = om.readValue(jsonParser, javaType);
            } else {
                result = this.objectMapper.get().treeToValue(node, targetType);
            }
            return Optional.ofNullable(result);
        }
        catch (IOException e) {
            context.reject(e);
            return Optional.empty();
        }
    }
}

