/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jackson.codec;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.micronaut.context.BeanProvider;
import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.MediaType;
import io.micronaut.http.codec.CodecConfiguration;
import io.micronaut.jackson.codec.JsonMediaTypeCodec;
import io.micronaut.runtime.ApplicationConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;

@Singleton
@BootstrapContextCompatible
public class JsonStreamMediaTypeCodec
extends JsonMediaTypeCodec {
    public static final String CONFIGURATION_QUALIFIER = "json-stream";
    private final List<MediaType> additionalTypes;

    public JsonStreamMediaTypeCodec(ObjectMapper objectMapper, ApplicationConfiguration applicationConfiguration, @Named(value="json-stream") @Nullable CodecConfiguration codecConfiguration) {
        super(objectMapper, applicationConfiguration, null);
        this.additionalTypes = codecConfiguration != null ? codecConfiguration.getAdditionalTypes() : Collections.emptyList();
    }

    @Deprecated
    public JsonStreamMediaTypeCodec(Provider<ObjectMapper> objectMapper, ApplicationConfiguration applicationConfiguration, @Named(value="json-stream") @Nullable CodecConfiguration codecConfiguration) {
        this(objectMapper::get, applicationConfiguration, codecConfiguration);
    }

    @Inject
    public JsonStreamMediaTypeCodec(BeanProvider<ObjectMapper> objectMapper, ApplicationConfiguration applicationConfiguration, @Named(value="json-stream") @Nullable CodecConfiguration codecConfiguration) {
        super(objectMapper, applicationConfiguration, null);
        this.additionalTypes = codecConfiguration != null ? codecConfiguration.getAdditionalTypes() : Collections.emptyList();
    }

    @Override
    public Collection<MediaType> getMediaTypes() {
        ArrayList<MediaType> mediaTypes = new ArrayList<MediaType>();
        mediaTypes.add(MediaType.APPLICATION_JSON_STREAM_TYPE);
        mediaTypes.addAll(this.additionalTypes);
        return mediaTypes;
    }
}

