/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.writer;

import io.micronaut.asm.ClassWriter;
import io.micronaut.asm.Type;
import io.micronaut.asm.commons.GeneratorAdapter;
import io.micronaut.context.AbstractBeanDefinitionReference;
import io.micronaut.context.annotation.ConfigurationReader;
import io.micronaut.context.annotation.DefaultScope;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.AdvisedBeanType;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.BeanDefinitionReference;
import io.micronaut.inject.writer.AbstractAnnotationMetadataWriter;
import io.micronaut.inject.writer.BeanDefinitionVisitor;
import io.micronaut.inject.writer.ClassWriterOutputVisitor;
import io.micronaut.inject.writer.OriginatingElements;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import javax.inject.Singleton;

@Internal
public class BeanDefinitionReferenceWriter
extends AbstractAnnotationMetadataWriter {
    public static final String REF_SUFFIX = "Class";
    private final String beanTypeName;
    private final String beanDefinitionName;
    private final String beanDefinitionClassInternalName;
    private final String beanDefinitionReferenceClassName;
    private final Type interceptedType;
    private boolean contextScope = false;
    private boolean requiresMethodProcessing;

    @Deprecated
    public BeanDefinitionReferenceWriter(String beanTypeName, String beanDefinitionName, OriginatingElements originatingElements, AnnotationMetadata annotationMetadata) {
        super(beanDefinitionName + REF_SUFFIX, originatingElements, annotationMetadata, true);
        this.beanTypeName = beanTypeName;
        this.beanDefinitionName = beanDefinitionName;
        this.beanDefinitionReferenceClassName = beanDefinitionName + REF_SUFFIX;
        this.beanDefinitionClassInternalName = BeanDefinitionReferenceWriter.getInternalName(beanDefinitionName) + REF_SUFFIX;
        this.interceptedType = null;
    }

    public BeanDefinitionReferenceWriter(String beanTypeName, BeanDefinitionVisitor visitor) {
        super(visitor.getBeanDefinitionName() + REF_SUFFIX, visitor, visitor.getAnnotationMetadata(), true);
        this.beanTypeName = beanTypeName;
        this.beanDefinitionName = visitor.getBeanDefinitionName();
        this.beanDefinitionReferenceClassName = this.beanDefinitionName + REF_SUFFIX;
        this.beanDefinitionClassInternalName = BeanDefinitionReferenceWriter.getInternalName(this.beanDefinitionName) + REF_SUFFIX;
        this.interceptedType = visitor.getInterceptedType().orElse(null);
    }

    @Override
    public void accept(ClassWriterOutputVisitor outputVisitor) throws IOException {
        try (OutputStream outputStream = outputVisitor.visitClass(this.getBeanDefinitionQualifiedClassName(), this.getOriginatingElements());){
            ClassWriter classWriter = this.generateClassBytes();
            outputStream.write(classWriter.toByteArray());
        }
        outputVisitor.visitServiceDescriptor(BeanDefinitionReference.class, this.beanDefinitionReferenceClassName);
    }

    public void setContextScope(boolean contextScope) {
        this.contextScope = contextScope;
    }

    public void setRequiresMethodProcessing(boolean shouldPreProcess) {
        this.requiresMethodProcessing = shouldPreProcess;
    }

    public String getBeanDefinitionQualifiedClassName() {
        String newClassName = this.beanDefinitionName;
        if (newClassName.endsWith("[]")) {
            newClassName = newClassName.substring(0, newClassName.length() - 2);
        }
        return newClassName + REF_SUFFIX;
    }

    private ClassWriter generateClassBytes() {
        ClassWriter classWriter = new ClassWriter(1);
        Type superType = Type.getType(AbstractBeanDefinitionReference.class);
        String[] interfaceInternalNames = this.interceptedType != null ? new String[]{Type.getType(AdvisedBeanType.class).getInternalName()} : StringUtils.EMPTY_STRING_ARRAY;
        this.startService(classWriter, BeanDefinitionReference.class.getName(), this.beanDefinitionClassInternalName, superType, interfaceInternalNames);
        Type beanDefinitionType = BeanDefinitionReferenceWriter.getTypeReferenceForName(this.beanDefinitionName, new String[0]);
        this.writeAnnotationMetadataStaticInitializer(classWriter);
        GeneratorAdapter cv = this.startConstructor(classWriter);
        cv.loadThis();
        cv.push(this.beanTypeName);
        cv.push(this.beanDefinitionName);
        this.invokeConstructor(cv, AbstractBeanDefinitionReference.class, String.class, String.class);
        cv.visitInsn(177);
        cv.visitMaxs(2, 1);
        GeneratorAdapter loadMethod = this.startPublicMethodZeroArgs(classWriter, BeanDefinition.class, "load");
        this.pushNewInstance(loadMethod, beanDefinitionType);
        loadMethod.returnValue();
        loadMethod.visitMaxs(2, 1);
        if (this.contextScope) {
            GeneratorAdapter isContextScopeMethod = this.startPublicMethodZeroArgs(classWriter, Boolean.TYPE, "isContextScope");
            isContextScopeMethod.push(true);
            isContextScopeMethod.returnValue();
            isContextScopeMethod.visitMaxs(1, 1);
        }
        GeneratorAdapter getBeanDefinitionType = this.startPublicMethodZeroArgs(classWriter, Class.class, "getBeanDefinitionType");
        getBeanDefinitionType.push(beanDefinitionType);
        getBeanDefinitionType.returnValue();
        getBeanDefinitionType.visitMaxs(2, 1);
        GeneratorAdapter getBeanType = this.startPublicMethodZeroArgs(classWriter, Class.class, "getBeanType");
        getBeanType.push(BeanDefinitionReferenceWriter.getTypeReferenceForName(this.beanTypeName, new String[0]));
        getBeanType.returnValue();
        getBeanType.visitMaxs(2, 1);
        if (this.requiresMethodProcessing) {
            GeneratorAdapter requiresMethodProcessing = this.startPublicMethod(classWriter, "requiresMethodProcessing", Boolean.TYPE.getName(), new String[0]);
            requiresMethodProcessing.push(true);
            requiresMethodProcessing.visitInsn(172);
            requiresMethodProcessing.visitMaxs(1, 1);
            requiresMethodProcessing.visitEnd();
        }
        this.writeGetAnnotationMetadataMethod(classWriter);
        this.writeBooleanMethod(classWriter, "isSingleton", () -> this.annotationMetadata.hasDeclaredStereotype((Class<? extends Annotation>)Singleton.class) || this.annotationMetadata.classValue(DefaultScope.class).map(t -> t == Singleton.class).orElse(false) != false);
        this.writeBooleanMethod(classWriter, "isConfigurationProperties", () -> this.annotationMetadata.hasDeclaredStereotype((Class<? extends Annotation>)ConfigurationReader.class));
        if (this.interceptedType != null) {
            super.implementInterceptedTypeMethod(this.interceptedType, classWriter);
        }
        for (GeneratorAdapter generatorAdapter : this.loadTypeMethods.values()) {
            generatorAdapter.visitMaxs(3, 1);
        }
        return classWriter;
    }
}

