/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.annotation.internal;

import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.annotation.NamedAnnotationMapper;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.visitor.VisitorContext;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;

@Internal
public class PersistenceContextAnnotationMapper
implements NamedAnnotationMapper {
    private static final String TARGET_ANNOTATION = "io.micronaut.configuration.hibernate.jpa.scope.CurrentSession";
    private static final String SOURCE_ANNOTATION = "javax.persistence.PersistenceContext";

    @Override
    public String getName() {
        return SOURCE_ANNOTATION;
    }

    @Override
    public List<AnnotationValue<?>> map(AnnotationValue<Annotation> annotation, VisitorContext visitorContext) {
        Optional<ClassElement> hibernateCurrentSession = visitorContext.getClassElement(TARGET_ANNOTATION);
        if (hibernateCurrentSession.isPresent()) {
            String name = annotation.stringValue("name").orElse(null);
            ArrayList annotationValues = new ArrayList(3);
            annotationValues.add(AnnotationValue.builder(Inject.class).build());
            annotationValues.add(AnnotationValue.builder(TARGET_ANNOTATION).value(name).build());
            if (StringUtils.isNotEmpty(name)) {
                annotationValues.add(AnnotationValue.builder(Named.class).value(name).build());
            }
            return annotationValues;
        }
        return Collections.emptyList();
    }
}

