/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.annotation;

import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.annotation.DefaultAnnotationMetadata;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MutableAnnotationMetadata
extends DefaultAnnotationMetadata {
    private boolean hasPropertyExpressions = false;

    @Override
    public boolean hasPropertyExpressions() {
        return this.hasPropertyExpressions;
    }

    @Override
    public void addAnnotation(String annotation, Map<CharSequence, Object> values) {
        this.hasPropertyExpressions = this.computeHasPropertyExpressions(values, RetentionPolicy.RUNTIME);
        super.addAnnotation(annotation, values);
    }

    @Override
    public void addAnnotation(String annotation, Map<CharSequence, Object> values, RetentionPolicy retentionPolicy) {
        this.hasPropertyExpressions = this.computeHasPropertyExpressions(values, retentionPolicy);
        super.addAnnotation(annotation, values, retentionPolicy);
    }

    @Override
    public void addRepeatableStereotype(List<String> parents, String stereotype, AnnotationValue annotationValue) {
        Objects.requireNonNull(annotationValue, "Annotation Value cannot be null");
        this.hasPropertyExpressions = this.computeHasPropertyExpressions(annotationValue.getValues(), RetentionPolicy.RUNTIME);
        super.addRepeatableStereotype(parents, stereotype, annotationValue);
    }

    @Override
    public void addDeclaredRepeatableStereotype(List<String> parents, String stereotype, AnnotationValue annotationValue) {
        Objects.requireNonNull(annotationValue, "Annotation Value cannot be null");
        this.hasPropertyExpressions = this.computeHasPropertyExpressions(annotationValue.getValues(), RetentionPolicy.RUNTIME);
        super.addDeclaredRepeatableStereotype(parents, stereotype, annotationValue);
    }

    @Override
    public void addDeclaredAnnotation(String annotation, Map<CharSequence, Object> values) {
        this.hasPropertyExpressions = this.computeHasPropertyExpressions(values, RetentionPolicy.RUNTIME);
        super.addDeclaredAnnotation(annotation, values);
    }

    @Override
    public void addDeclaredAnnotation(String annotation, Map<CharSequence, Object> values, RetentionPolicy retentionPolicy) {
        this.hasPropertyExpressions = this.computeHasPropertyExpressions(values, retentionPolicy);
        super.addDeclaredAnnotation(annotation, values, retentionPolicy);
    }

    @Override
    protected void addRepeatable(String annotationName, AnnotationValue annotationValue) {
        Objects.requireNonNull(annotationValue, "Annotation Value cannot be null");
        this.hasPropertyExpressions = this.computeHasPropertyExpressions(annotationValue.getValues(), RetentionPolicy.RUNTIME);
        super.addRepeatable(annotationName, annotationValue);
    }

    @Override
    protected void addRepeatable(String annotationName, AnnotationValue annotationValue, RetentionPolicy retentionPolicy) {
        Objects.requireNonNull(annotationValue, "Annotation Value cannot be null");
        this.hasPropertyExpressions = this.computeHasPropertyExpressions(annotationValue.getValues(), retentionPolicy);
        super.addRepeatable(annotationName, annotationValue, retentionPolicy);
    }

    @Override
    protected void addDeclaredRepeatable(String annotationName, AnnotationValue annotationValue) {
        Objects.requireNonNull(annotationValue, "Annotation Value cannot be null");
        this.hasPropertyExpressions = this.computeHasPropertyExpressions(annotationValue.getValues(), RetentionPolicy.RUNTIME);
        super.addDeclaredRepeatable(annotationName, annotationValue);
    }

    @Override
    protected void addDeclaredRepeatable(String annotationName, AnnotationValue annotationValue, RetentionPolicy retentionPolicy) {
        Objects.requireNonNull(annotationValue, "Annotation Value cannot be null");
        this.hasPropertyExpressions = this.computeHasPropertyExpressions(annotationValue.getValues(), retentionPolicy);
        super.addDeclaredRepeatable(annotationName, annotationValue, retentionPolicy);
    }

    private boolean computeHasPropertyExpressions(Map<CharSequence, Object> values, RetentionPolicy retentionPolicy) {
        return this.hasPropertyExpressions || values != null && retentionPolicy == RetentionPolicy.RUNTIME && this.hasPropertyExpressions(values);
    }

    private boolean hasPropertyExpressions(Map<CharSequence, Object> values) {
        if (CollectionUtils.isEmpty(values)) {
            return false;
        }
        return values.values().stream().anyMatch(v -> {
            if (v instanceof CharSequence) {
                return v.toString().contains("${");
            }
            if (v instanceof String[]) {
                return Arrays.stream((String[])v).anyMatch(s -> s.contains("${"));
            }
            if (v instanceof AnnotationValue) {
                return this.hasPropertyExpressions(((AnnotationValue)v).getValues());
            }
            if (v instanceof AnnotationValue[]) {
                AnnotationValue[] a = (AnnotationValue[])v;
                if (a.length > 0) {
                    return Arrays.stream(a).anyMatch(av -> this.hasPropertyExpressions(av.getValues()));
                }
                return false;
            }
            return false;
        });
    }
}

