/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.util;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.server.util.HttpClientAddressResolver;
import io.micronaut.http.server.util.ProxyHeaderParser;
import java.net.InetSocketAddress;
import java.util.List;
import javax.inject.Singleton;

@Singleton
public class DefaultHttpClientAddressResolver
implements HttpClientAddressResolver {
    private final HttpServerConfiguration serverConfiguration;

    public DefaultHttpClientAddressResolver(HttpServerConfiguration serverConfiguration) {
        this.serverConfiguration = serverConfiguration;
    }

    @Override
    @Nullable
    public String resolve(@NonNull HttpRequest request) {
        String configuredHeader = this.serverConfiguration.getClientAddressHeader();
        if (configuredHeader != null) {
            return (String)request.getHeaders().get(configuredHeader);
        }
        ProxyHeaderParser proxyHeaderParser = new ProxyHeaderParser(request);
        List<String> addresses = proxyHeaderParser.getFor();
        if (addresses.isEmpty()) {
            InetSocketAddress address = request.getRemoteAddress();
            if (address != null) {
                return address.getHostString();
            }
            return null;
        }
        return addresses.get(0);
    }
}

