/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.jackson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JsonNode;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.async.subscriber.CompletionAwareSubscriber;
import io.micronaut.core.async.subscriber.TypedSubscriber;
import io.micronaut.core.type.Argument;
import io.micronaut.http.MediaType;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.server.netty.AbstractHttpContentProcessor;
import io.micronaut.http.server.netty.NettyHttpRequest;
import io.micronaut.jackson.parser.JacksonProcessor;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.ByteBufUtil;
import io.netty.util.ReferenceCountUtil;
import java.util.Optional;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

@Internal
public class JsonContentProcessor
extends AbstractHttpContentProcessor<JsonNode> {
    private final JsonFactory jsonFactory;
    private final DeserializationConfig deserializationConfig;
    private JacksonProcessor jacksonProcessor;

    public JsonContentProcessor(NettyHttpRequest<?> nettyHttpRequest, HttpServerConfiguration configuration, @Nullable JsonFactory jsonFactory, DeserializationConfig deserializationConfig) {
        super(nettyHttpRequest, configuration);
        this.jsonFactory = jsonFactory != null ? jsonFactory : new JsonFactory();
        this.deserializationConfig = deserializationConfig;
    }

    @Override
    protected void doOnSubscribe(Subscription subscription, final Subscriber<? super JsonNode> subscriber) {
        Optional<Argument<?>> genericArgument;
        TypedSubscriber typedSubscriber;
        Argument typeArgument;
        Class targetType;
        if (this.parentSubscription == null) {
            return;
        }
        boolean streamArray = false;
        boolean isJsonStream = this.nettyHttpRequest.getContentType().map(mediaType -> mediaType.equals(MediaType.APPLICATION_JSON_STREAM_TYPE)).orElse(false);
        if (subscriber instanceof TypedSubscriber && Publishers.isConvertibleToPublisher(targetType = (typeArgument = (typedSubscriber = (TypedSubscriber)subscriber).getTypeArgument()).getType()) && !Publishers.isSingle(targetType) && (genericArgument = typeArgument.getFirstTypeVariable()).isPresent() && !Iterable.class.isAssignableFrom(genericArgument.get().getType()) && !isJsonStream) {
            streamArray = true;
        }
        this.jacksonProcessor = new JacksonProcessor(this.jsonFactory, streamArray, this.deserializationConfig);
        this.jacksonProcessor.subscribe(new CompletionAwareSubscriber<JsonNode>(){

            @Override
            protected void doOnSubscribe(final Subscription jsonSubscription) {
                Subscription childSubscription = new Subscription(){
                    boolean first = true;

                    @Override
                    public synchronized void request(long n) {
                        if (this.first) {
                            jsonSubscription.request(n < Long.MAX_VALUE ? n + 1L : n);
                            JsonContentProcessor.this.parentSubscription.request(n < Long.MAX_VALUE ? n + 1L : n);
                        } else {
                            jsonSubscription.request(n);
                            JsonContentProcessor.this.parentSubscription.request(n);
                        }
                    }

                    @Override
                    public synchronized void cancel() {
                        jsonSubscription.cancel();
                        JsonContentProcessor.this.parentSubscription.cancel();
                    }
                };
                subscriber.onSubscribe(childSubscription);
            }

            @Override
            protected void doOnNext(JsonNode message) {
                subscriber.onNext(message);
            }

            @Override
            protected void doOnError(Throwable t) {
                subscriber.onError(t);
            }

            @Override
            protected void doOnComplete() {
                subscriber.onComplete();
            }
        });
        this.jacksonProcessor.onSubscribe(subscription);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onData(ByteBufHolder message) {
        ByteBuf content = message.content();
        try {
            byte[] bytes = ByteBufUtil.getBytes(content);
            this.jacksonProcessor.onNext(bytes);
        }
        finally {
            ReferenceCountUtil.release(content);
        }
    }

    @Override
    protected void doAfterOnError(Throwable throwable) {
        this.jacksonProcessor.onError(throwable);
    }

    @Override
    protected void doOnComplete() {
        this.jacksonProcessor.onComplete();
        super.doOnComplete();
    }
}

