/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.handler.accesslog.element;

import io.micronaut.http.server.netty.handler.accesslog.element.AbstractHttpMessageLogElement;
import io.micronaut.http.server.netty.handler.accesslog.element.LogElement;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import java.util.List;
import java.util.StringJoiner;

final class CookiesElement
extends AbstractHttpMessageLogElement {
    public static final String REQUEST_COOKIES = "C";
    public static final String RESPONSE_COOKIES = "c";
    private static final CookiesElement REQUEST_COOKIES_ELEMENT = new CookiesElement(HttpHeaderNames.COOKIE.toString());
    private static final CookiesElement RESPONSE_COOKIES_ELEMENT = new CookiesElement(HttpHeaderNames.SET_COOKIE.toString());
    private final String headerName;

    private CookiesElement(String headerName) {
        this.headerName = HttpHeaderNames.COOKIE.toString().equals(headerName) || HttpHeaderNames.SET_COOKIE.toString().equals(headerName) ? headerName : HttpHeaderNames.COOKIE.toString();
        this.events = HttpHeaderNames.COOKIE.toString().equals(this.headerName) ? LogElement.Event.REQUEST_HEADERS_EVENTS : LogElement.Event.RESPONSE_HEADERS_EVENTS;
    }

    public static CookiesElement forRequest() {
        return REQUEST_COOKIES_ELEMENT;
    }

    public static CookiesElement forResponse() {
        return RESPONSE_COOKIES_ELEMENT;
    }

    @Override
    protected String value(HttpHeaders headers) {
        String header = headers.get(this.headerName);
        if (header != null) {
            List<Cookie> cookies = ServerCookieDecoder.STRICT.decodeAll(header);
            if (cookies.isEmpty()) {
                return "-";
            }
            if (cookies.size() == 1) {
                Cookie cookie = cookies.iterator().next();
                return cookie.name() + ':' + cookie.value();
            }
            StringJoiner joiner = new StringJoiner(",", "[", "]");
            for (Cookie cookie : cookies) {
                joiner.add(cookie.name() + ':' + cookie.value());
            }
            return joiner.toString();
        }
        return "-";
    }

    public String toString() {
        return '%' + (HttpHeaderNames.COOKIE.toString().equals(this.headerName) ? REQUEST_COOKIES : RESPONSE_COOKIES);
    }
}

