/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.converters;

import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.hateoas.JsonError;
import io.micronaut.http.hateoas.Link;
import io.micronaut.http.server.exceptions.ExceptionHandler;
import io.micronaut.http.server.exceptions.response.ErrorContext;
import io.micronaut.http.server.exceptions.response.ErrorResponseProcessor;
import io.micronaut.web.router.exceptions.DuplicateRouteException;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
@Produces
public class DuplicateRouteHandler
implements ExceptionHandler<DuplicateRouteException, HttpResponse> {
    private final ErrorResponseProcessor<?> responseProcessor;

    @Deprecated
    public DuplicateRouteHandler() {
        this.responseProcessor = null;
    }

    @Inject
    public DuplicateRouteHandler(ErrorResponseProcessor<?> responseProcessor) {
        this.responseProcessor = responseProcessor;
    }

    @Override
    public HttpResponse handle(HttpRequest request, DuplicateRouteException exception) {
        MutableHttpResponse response = HttpResponse.badRequest();
        if (this.responseProcessor != null) {
            return this.responseProcessor.processResponse(ErrorContext.builder(request).cause(exception).errorMessage(exception.getMessage()).build(), response);
        }
        return response.body(new JsonError(exception.getMessage()).link(Link.SELF, Link.of(request.getUri())));
    }
}

