/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.exceptions;

import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.hateoas.JsonError;
import io.micronaut.http.server.exceptions.ExceptionHandler;
import io.micronaut.http.server.exceptions.response.Error;
import io.micronaut.http.server.exceptions.response.ErrorContext;
import io.micronaut.http.server.exceptions.response.ErrorResponseProcessor;
import java.net.URISyntaxException;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
@Produces
public class URISyntaxHandler
implements ExceptionHandler<URISyntaxException, HttpResponse> {
    private final ErrorResponseProcessor<?> responseProcessor;

    @Deprecated
    public URISyntaxHandler() {
        this.responseProcessor = null;
    }

    @Inject
    public URISyntaxHandler(ErrorResponseProcessor<?> responseProcessor) {
        this.responseProcessor = responseProcessor;
    }

    @Override
    public HttpResponse handle(HttpRequest request, final URISyntaxException exception) {
        MutableHttpResponse response = HttpResponse.badRequest();
        if (this.responseProcessor != null) {
            return this.responseProcessor.processResponse(ErrorContext.builder(request).cause(exception).error(new Error(){

                @Override
                public String getMessage() {
                    return "Malformed URI: " + exception.getMessage();
                }

                @Override
                public Optional<String> getTitle() {
                    return Optional.of("Malformed URI");
                }
            }).build(), response);
        }
        return response.body(new JsonError("Malformed URI: " + exception.getMessage()));
    }
}

