/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.exceptions;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.hateoas.JsonError;
import io.micronaut.http.hateoas.Link;
import io.micronaut.http.server.exceptions.ExceptionHandler;
import io.micronaut.http.server.exceptions.response.Error;
import io.micronaut.http.server.exceptions.response.ErrorContext;
import io.micronaut.http.server.exceptions.response.ErrorResponseProcessor;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Produces
@Singleton
public class JsonExceptionHandler
implements ExceptionHandler<JsonProcessingException, Object> {
    private final ErrorResponseProcessor<?> responseProcessor;

    @Deprecated
    public JsonExceptionHandler() {
        this.responseProcessor = null;
    }

    @Inject
    public JsonExceptionHandler(ErrorResponseProcessor<?> responseProcessor) {
        this.responseProcessor = responseProcessor;
    }

    @Override
    public Object handle(HttpRequest request, final JsonProcessingException exception) {
        MutableHttpResponse response = HttpResponse.status(HttpStatus.BAD_REQUEST, "Invalid JSON");
        if (this.responseProcessor != null) {
            return this.responseProcessor.processResponse(ErrorContext.builder(request).cause(exception).error(new Error(){

                @Override
                public String getMessage() {
                    return "Invalid JSON: " + exception.getMessage();
                }

                @Override
                public Optional<String> getTitle() {
                    return Optional.of("Invalid JSON");
                }
            }).build(), response);
        }
        return response.body(new JsonError("Invalid JSON: " + exception.getMessage()).link(Link.SELF, Link.of(request.getUri())));
    }
}

