/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.binding;

import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.bind.binders.TypedRequestArgumentBinder;
import io.micronaut.http.server.util.locale.HttpLocaleResolver;
import java.util.Locale;
import java.util.Optional;
import javax.inject.Singleton;

@Singleton
public class LocaleArgumentBinder
implements TypedRequestArgumentBinder<Locale> {
    private final HttpLocaleResolver localeResolver;

    public LocaleArgumentBinder(HttpLocaleResolver localeResolver) {
        this.localeResolver = localeResolver;
    }

    @Override
    public Argument<Locale> argumentType() {
        return Argument.of(Locale.class);
    }

    @Override
    public ArgumentBinder.BindingResult<Locale> bind(ArgumentConversionContext<Locale> context, HttpRequest<?> source) {
        Optional<Locale> locale = this.localeResolver.resolve(source);
        if (locale.isPresent()) {
            return () -> locale;
        }
        return ArgumentBinder.BindingResult.UNSATISFIED;
    }
}

