/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.filter;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.filter.HttpFilter;
import io.micronaut.http.filter.HttpFilterResolver;
import java.util.Collections;
import java.util.Set;

final class DefaultFilterEntry<T extends HttpFilter>
implements HttpFilterResolver.FilterEntry<T> {
    private final T httpFilter;
    private final AnnotationMetadata annotationMetadata;
    private final Set<HttpMethod> filterMethods;
    private final String[] patterns;
    private final boolean hasMethods;
    private final boolean hasPatterns;

    DefaultFilterEntry(T filter, AnnotationMetadata annotationMetadata, Set<HttpMethod> httpMethods, String[] patterns) {
        this.httpFilter = filter;
        this.annotationMetadata = annotationMetadata;
        this.filterMethods = httpMethods != null ? Collections.unmodifiableSet(httpMethods) : Collections.emptySet();
        this.patterns = patterns != null ? patterns : StringUtils.EMPTY_STRING_ARRAY;
        this.hasMethods = CollectionUtils.isNotEmpty(this.filterMethods);
        this.hasPatterns = ArrayUtils.isNotEmpty(patterns);
    }

    @Override
    @NonNull
    public AnnotationMetadata getAnnotationMetadata() {
        return this.annotationMetadata;
    }

    @Override
    public T getFilter() {
        return this.httpFilter;
    }

    @Override
    public Set<HttpMethod> getFilterMethods() {
        return this.filterMethods;
    }

    @Override
    public String[] getPatterns() {
        return this.patterns;
    }

    @Override
    public boolean hasMethods() {
        return this.hasMethods;
    }

    @Override
    public boolean hasPatterns() {
        return this.hasPatterns;
    }
}

