/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client;

import io.micronaut.context.BeanContext;
import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.discovery.ServiceInstanceList;
import io.micronaut.http.client.LoadBalancer;
import io.micronaut.http.client.LoadBalancerResolver;
import io.micronaut.http.client.loadbalance.DiscoveryClientLoadBalancerFactory;
import io.micronaut.http.client.loadbalance.ServiceInstanceListLoadBalancerFactory;
import io.micronaut.runtime.server.EmbeddedServer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
@BootstrapContextCompatible
public class DefaultLoadBalancerResolver
implements LoadBalancerResolver {
    private final Map<String, ServiceInstanceList> serviceInstanceLists;
    private final BeanContext beanContext;

    public DefaultLoadBalancerResolver(BeanContext beanContext, ServiceInstanceList ... serviceInstanceLists) {
        this(beanContext, Arrays.asList(serviceInstanceLists));
    }

    @Inject
    public DefaultLoadBalancerResolver(BeanContext beanContext, List<ServiceInstanceList> serviceInstanceLists) {
        this.beanContext = beanContext;
        if (CollectionUtils.isNotEmpty(serviceInstanceLists)) {
            this.serviceInstanceLists = new HashMap<String, ServiceInstanceList>(serviceInstanceLists.size());
            for (ServiceInstanceList provider : serviceInstanceLists) {
                this.serviceInstanceLists.put(provider.getID(), provider);
            }
        } else {
            this.serviceInstanceLists = Collections.emptyMap();
        }
    }

    @Override
    public Optional<? extends LoadBalancer> resolve(String ... serviceReferences) {
        if (ArrayUtils.isEmpty(serviceReferences) || StringUtils.isEmpty(serviceReferences[0])) {
            return Optional.empty();
        }
        String reference = serviceReferences[0];
        if (reference.startsWith("/")) {
            if (this.beanContext.containsBean(EmbeddedServer.class)) {
                EmbeddedServer embeddedServer = this.beanContext.getBean(EmbeddedServer.class);
                URL url = embeddedServer.getURL();
                return Optional.of(LoadBalancer.fixed(url));
            }
            return Optional.empty();
        }
        if (reference.indexOf(47) > -1) {
            try {
                URL url = new URL(reference);
                return Optional.of(LoadBalancer.fixed(url));
            }
            catch (MalformedURLException e) {
                return Optional.empty();
            }
        }
        reference = NameUtils.hyphenate(reference);
        return this.resolveLoadBalancerForServiceID(reference);
    }

    protected Optional<? extends LoadBalancer> resolveLoadBalancerForServiceID(String serviceID) {
        if (this.serviceInstanceLists.containsKey(serviceID)) {
            ServiceInstanceList serviceInstanceList = this.serviceInstanceLists.get(serviceID);
            LoadBalancer loadBalancer = this.beanContext.getBean(ServiceInstanceListLoadBalancerFactory.class).create(serviceInstanceList);
            return Optional.ofNullable(loadBalancer);
        }
        LoadBalancer loadBalancer = this.beanContext.getBean(DiscoveryClientLoadBalancerFactory.class).create(serviceID);
        return Optional.of(loadBalancer);
    }
}

