/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery;

import io.micronaut.context.env.Environment;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.discovery.EmbeddedServerInstance;
import io.micronaut.discovery.ServiceInstance;
import io.micronaut.discovery.ServiceInstanceIdGenerator;
import java.util.Optional;
import java.util.StringJoiner;
import javax.inject.Singleton;

@Singleton
public class DefaultServiceInstanceIdGenerator
implements ServiceInstanceIdGenerator {
    protected DefaultServiceInstanceIdGenerator() {
    }

    @Override
    @NonNull
    public String generateId(Environment environment, ServiceInstance serviceInstance) {
        Optional<String> cloudFoundryId = environment.getProperty("vcap.application.instance_id", String.class);
        if (cloudFoundryId.isPresent()) {
            return cloudFoundryId.get();
        }
        StringJoiner joiner = new StringJoiner(":");
        String applicationName = serviceInstance.getId();
        joiner.add(applicationName);
        if (serviceInstance instanceof EmbeddedServerInstance) {
            EmbeddedServerInstance esi = (EmbeddedServerInstance)serviceInstance;
            Optional<String> id = esi.getEmbeddedServer().getApplicationConfiguration().getInstance().getId();
            if (id.isPresent()) {
                joiner.add(id.get());
            } else {
                joiner.add(String.valueOf(esi.getPort()));
            }
        } else {
            joiner.add(String.valueOf(serviceInstance.getPort()));
        }
        return joiner.toString();
    }
}

