/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.beans;

import io.micronaut.core.annotation.AnnotationMetadataDelegate;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.beans.BeanIntrospector;
import io.micronaut.core.beans.BeanMethod;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.beans.exceptions.IntrospectionException;
import io.micronaut.core.naming.Named;
import io.micronaut.core.reflect.exception.InstantiationException;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArgumentUtils;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public interface BeanIntrospection<T>
extends AnnotationMetadataDelegate {
    @NonNull
    public Collection<BeanProperty<T, Object>> getBeanProperties();

    @NonNull
    public Collection<BeanProperty<T, Object>> getIndexedProperties(@NonNull Class<? extends Annotation> var1);

    @NonNull
    public T instantiate() throws InstantiationException;

    @NonNull
    default public T instantiate(Object ... arguments) throws InstantiationException {
        return this.instantiate(true, arguments);
    }

    @NonNull
    public T instantiate(boolean var1, Object ... var2) throws InstantiationException;

    @NonNull
    public Class<T> getBeanType();

    @NonNull
    public Optional<BeanProperty<T, Object>> getIndexedProperty(@NonNull Class<? extends Annotation> var1, @NonNull String var2);

    @NonNull
    default public Collection<BeanMethod<T, Object>> getBeanMethods() {
        return Collections.emptyList();
    }

    @NonNull
    default public Optional<BeanProperty<T, Object>> getIndexedProperty(@NonNull Class<? extends Annotation> annotationType) {
        return this.getIndexedProperties(annotationType).stream().findFirst();
    }

    @NonNull
    default public Argument<?>[] getConstructorArguments() {
        return Argument.ZERO_ARGUMENTS;
    }

    @NonNull
    default public Optional<BeanProperty<T, Object>> getProperty(@NonNull String name) {
        return Optional.empty();
    }

    @NonNull
    default public <P> BeanProperty<T, P> getRequiredProperty(@NonNull String name, @NonNull Class<P> type) {
        return this.getProperty(name, type).orElseThrow(() -> new IntrospectionException("No property [" + name + "] of type [" + type + "] present"));
    }

    @NonNull
    default public <P> Optional<BeanProperty<T, P>> getProperty(@NonNull String name, @NonNull Class<P> type) {
        ArgumentUtils.requireNonNull("name", name);
        ArgumentUtils.requireNonNull("type", type);
        BeanProperty prop = this.getProperty(name).orElse(null);
        if (prop != null && type.isAssignableFrom(prop.getType())) {
            return Optional.of(prop);
        }
        return Optional.empty();
    }

    @NonNull
    default public String[] getPropertyNames() {
        return (String[])this.getBeanProperties().stream().map(Named::getName).toArray(String[]::new);
    }

    public static <T2> BeanIntrospection<T2> getIntrospection(Class<T2> type) {
        return BeanIntrospector.SHARED.getIntrospection(type);
    }
}

