/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.context.AbstractBeanContextConditional;
import io.micronaut.context.BeanContext;
import io.micronaut.context.BeanResolutionContext;
import io.micronaut.context.DefaultBeanContext;
import io.micronaut.context.ProviderFactory;
import io.micronaut.context.Qualifier;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.exceptions.BeanInstantiationException;
import io.micronaut.context.exceptions.NoSuchBeanException;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.naming.NameResolver;
import io.micronaut.core.naming.Named;
import io.micronaut.core.type.Argument;
import io.micronaut.core.value.ValueResolver;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.BeanFactory;
import io.micronaut.inject.DelegatingBeanDefinition;
import io.micronaut.inject.DisposableBeanDefinition;
import io.micronaut.inject.InitializingBeanDefinition;
import io.micronaut.inject.InjectionPoint;
import io.micronaut.inject.ParametrizedBeanFactory;
import io.micronaut.inject.ValidatedBeanDefinition;
import io.micronaut.inject.qualifiers.Qualifiers;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Provider;

@Internal
class BeanDefinitionDelegate<T>
extends AbstractBeanContextConditional
implements DelegatingBeanDefinition<T>,
BeanFactory<T>,
NameResolver,
ValueResolver<String> {
    static final String PRIMARY_ATTRIBUTE = Primary.class.getName();
    protected final BeanDefinition<T> definition;
    protected final Map<String, Object> attributes = new HashMap<String, Object>(2);

    private BeanDefinitionDelegate(BeanDefinition<T> definition) {
        this.definition = definition;
    }

    @Override
    @Nullable
    public Qualifier<T> resolveDynamicQualifier() {
        Qualifier qualifier = null;
        Object o = this.attributes.get(NAMED_ATTRIBUTE);
        if (o instanceof CharSequence) {
            qualifier = Qualifiers.byName(o.toString());
        }
        return qualifier;
    }

    BeanDefinition<T> getDelegate() {
        return this.definition;
    }

    @Override
    public boolean isProxy() {
        return this.definition.isProxy();
    }

    @Override
    public boolean isIterable() {
        return this.definition.isIterable();
    }

    @Override
    public boolean isPrimary() {
        return this.definition.isPrimary() || this.isPrimaryThroughAttribute();
    }

    private boolean isPrimaryThroughAttribute() {
        Object o = this.attributes.get(PRIMARY_ATTRIBUTE);
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        return false;
    }

    @Override
    public T build(BeanResolutionContext resolutionContext, BeanContext context, BeanDefinition<T> definition) throws BeanInstantiationException {
        LinkedHashMap<String, Object> oldAttributes = null;
        if (!this.attributes.isEmpty()) {
            LinkedHashMap<String, Object> oldAttrs = new LinkedHashMap<String, Object>(this.attributes.size());
            this.attributes.forEach((key, value) -> {
                Object previous = resolutionContext.setAttribute((CharSequence)key, value);
                if (previous != null) {
                    oldAttrs.put((String)key, previous);
                }
            });
            oldAttributes = oldAttrs;
        }
        try {
            if (this.definition instanceof ParametrizedBeanFactory) {
                ParametrizedBeanFactory parametrizedBeanFactory = (ParametrizedBeanFactory)((Object)this.definition);
                Argument<?>[] requiredArguments = parametrizedBeanFactory.getRequiredArguments();
                Object named = this.attributes.get(Named.class.getName());
                if (named != null) {
                    LinkedHashMap<String, Object> fulfilled = new LinkedHashMap<String, Object>(requiredArguments.length);
                    for (Argument<?> argument : requiredArguments) {
                        Class argumentType = argument.getType();
                        Optional<?> result = ConversionService.SHARED.convert(named, argument);
                        String argumentName = argument.getName();
                        if (result.isPresent()) {
                            fulfilled.put(argumentName, result.get());
                            continue;
                        }
                        Qualifier qualifier = Qualifiers.byName(named.toString());
                        if (ProviderFactory.isProvider(argumentType)) {
                            Optional<Argument<?>> genericType = argument.getFirstTypeVariable();
                            if (!genericType.isPresent()) continue;
                            Class beanType = genericType.get().getType();
                            try {
                                Provider provider = ((DefaultBeanContext)context).getBeanProvider(resolutionContext, beanType, qualifier);
                                if (provider != null) {
                                    fulfilled.put(argumentName, ProviderFactory.createProvider(argumentType, provider::get).orElse(null));
                                    continue;
                                }
                                fulfilled.put(argumentName, null);
                            }
                            catch (NoSuchBeanException noSuchBeanException) {}
                            continue;
                        }
                        Optional bean = ((DefaultBeanContext)context).findBean(resolutionContext, argumentType, qualifier);
                        if (!bean.isPresent()) continue;
                        fulfilled.put(argumentName, bean.get());
                    }
                    T t = parametrizedBeanFactory.build(resolutionContext, context, definition, fulfilled);
                    return t;
                }
            }
            if (this.definition instanceof BeanFactory) {
                T t = ((BeanFactory)((Object)this.definition)).build(resolutionContext, context, definition);
                return t;
            }
            throw new IllegalStateException("Cannot construct a dynamically registered singleton");
        }
        finally {
            for (String key2 : this.attributes.keySet()) {
                resolutionContext.removeAttribute(key2);
            }
            if (oldAttributes != null) {
                oldAttributes.forEach(resolutionContext::setAttribute);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BeanDefinitionDelegate that = (BeanDefinitionDelegate)o;
        return Objects.equals(this.definition, that.definition) && Objects.equals(this.resolveName().orElse(null), that.resolveName().orElse(null));
    }

    public int hashCode() {
        return Objects.hash(this.definition, this.resolveName().orElse(null));
    }

    @Override
    public BeanDefinition<T> getTarget() {
        return this.definition;
    }

    @Override
    public Optional<String> resolveName() {
        return this.get(Named.class.getName(), String.class);
    }

    public void put(String name, Object value) {
        this.attributes.put(name, value);
    }

    @Override
    public <T> Optional<T> get(String name, ArgumentConversionContext<T> conversionContext) {
        Object value = this.attributes.get(name);
        if (value != null && conversionContext.getArgument().getType().isInstance(value)) {
            return Optional.of(value);
        }
        return Optional.empty();
    }

    public String toString() {
        return this.definition.toString();
    }

    static <T> BeanDefinitionDelegate<T> create(BeanDefinition<T> definition) {
        if (definition instanceof InitializingBeanDefinition || definition instanceof DisposableBeanDefinition) {
            if (definition instanceof ValidatedBeanDefinition) {
                return new LifeCycleValidatingDelegate(definition);
            }
            return new LifeCycleDelegate(definition);
        }
        if (definition instanceof ValidatedBeanDefinition) {
            return new ValidatingDelegate(definition);
        }
        return new BeanDefinitionDelegate<T>(definition);
    }

    @Override
    public String getName() {
        return this.definition.getName();
    }

    private static final class LifeCycleValidatingDelegate<T>
    extends BeanDefinitionDelegate<T>
    implements ProxyValidatingBeanDefinition<T>,
    ProxyInitializingBeanDefinition<T>,
    ProxyDisposableBeanDefinition<T> {
        private LifeCycleValidatingDelegate(BeanDefinition<T> definition) {
            super(definition);
        }
    }

    private static final class ValidatingDelegate<T>
    extends BeanDefinitionDelegate<T>
    implements ProxyValidatingBeanDefinition<T> {
        private ValidatingDelegate(BeanDefinition<T> definition) {
            super(definition);
        }
    }

    private static final class LifeCycleDelegate<T>
    extends BeanDefinitionDelegate<T>
    implements ProxyInitializingBeanDefinition<T>,
    ProxyDisposableBeanDefinition<T> {
        private LifeCycleDelegate(BeanDefinition<T> definition) {
            super(definition);
        }
    }

    static interface ProxyValidatingBeanDefinition<T>
    extends DelegatingBeanDefinition<T>,
    ValidatedBeanDefinition<T> {
        @Override
        default public T validate(BeanResolutionContext resolutionContext, T instance) {
            BeanDefinition definition = this.getTarget();
            if (definition instanceof ValidatedBeanDefinition) {
                return ((ValidatedBeanDefinition)definition).validate(resolutionContext, instance);
            }
            return instance;
        }

        @Override
        default public <V> void validateBeanArgument(@NonNull BeanResolutionContext resolutionContext, @NonNull InjectionPoint injectionPoint, @NonNull Argument<V> argument, int index, @Nullable V value) {
            BeanDefinition definition = this.getTarget();
            if (definition instanceof ValidatedBeanDefinition) {
                ((ValidatedBeanDefinition)definition).validateBeanArgument(resolutionContext, injectionPoint, argument, index, value);
            }
        }
    }

    static interface ProxyDisposableBeanDefinition<T>
    extends DelegatingBeanDefinition<T>,
    DisposableBeanDefinition<T> {
        @Override
        default public T dispose(BeanResolutionContext resolutionContext, BeanContext context, T bean) {
            BeanDefinition definition = this.getTarget();
            if (definition instanceof DisposableBeanDefinition) {
                return ((DisposableBeanDefinition)definition).dispose(resolutionContext, context, bean);
            }
            return bean;
        }
    }

    static interface ProxyInitializingBeanDefinition<T>
    extends DelegatingBeanDefinition<T>,
    InitializingBeanDefinition<T> {
        @Override
        default public T initialize(BeanResolutionContext resolutionContext, BeanContext context, T bean) {
            BeanDefinition definition = this.getTarget();
            if (definition instanceof InitializingBeanDefinition) {
                return ((InitializingBeanDefinition)definition).initialize(resolutionContext, context, bean);
            }
            return bean;
        }
    }
}

